/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.VersionHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class ElevatorObstructionService {
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        Elevators.pushAndHoldLog();
        initialized = true;
        Elevators.popLog(logData -> Elevators.log("Obstruction service enabled. " + ChatColor.YELLOW + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static double getHitBoxAddition(Block block, Player player) {
        double height;
        BoundingBox originalBox = player.getBoundingBox();
        double newMinX = originalBox.getMinX() < 0.0 ? 1.0 + originalBox.getMinX() % 1.0 : originalBox.getMinX() % 1.0;
        double newMinZ = originalBox.getMinZ() < 0.0 ? 1.0 + originalBox.getMinZ() % 1.0 : originalBox.getMinZ() % 1.0;
        double newMinY = originalBox.getMinY() < 0.0 ? 1.0 + originalBox.getMinY() % 1.0 : originalBox.getMinY() % 1.0;
        BoundingBox box = new BoundingBox(newMinX, newMinY, newMinZ, newMinX + originalBox.getWidthX(), newMinY + originalBox.getHeight(), newMinZ + originalBox.getWidthZ());
        double bottomOverlapY = 0.0;
        double topOverlapY = 0.0;
        if (block.getType() != Material.AIR && !block.isPassable()) {
            for (BoundingBox blockBB : VersionHelper.getBoundingBoxes(block)) {
                if (!blockBB.overlaps(box)) continue;
                bottomOverlapY = Math.max(bottomOverlapY, blockBB.intersection(box).getMaxY());
            }
        }
        Block tempBlock = block;
        BoundingBox cloneBox = new BoundingBox(box.getMinX(), box.getMinY() - bottomOverlapY, box.getMinZ(), box.getMaxX(), box.getMaxY() - bottomOverlapY, box.getMaxZ());
        for (int i = 1; i <= 2; ++i) {
            topOverlapY = i + 1;
            if ((tempBlock = tempBlock.getRelative(BlockFace.UP)).isPassable()) continue;
            for (BoundingBox blockBB : VersionHelper.getBoundingBoxes(tempBlock)) {
                if (!blockBB.overlaps(cloneBox)) continue;
                topOverlapY = Math.min(topOverlapY, (double)i + blockBB.intersection(cloneBox).getMinY());
            }
            if (topOverlapY != (double)(i + 1)) break;
        }
        if ((height = topOverlapY - bottomOverlapY) < box.getHeight()) {
            return -1.0;
        }
        double addition = height >= box.getHeight() ? bottomOverlapY : -bottomOverlapY;
        return addition >= 1.0 ? -1.0 : addition;
    }
}

