/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.ArrayList;
import java.util.Locale;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.localization.BentoBoxLocale;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class BentoBoxHook
extends ProtectionHook {
    Flag useFlag = new Flag.Builder("USE_ELEVATOR", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();
    Flag editNameFlag = new Flag.Builder("EDIT_ELEVATOR_FLOOR_NAME", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();
    Flag editSettingsFlag = new Flag.Builder("EDIT_ELEVATOR_SETTINGS", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();

    public BentoBoxHook() {
        super("BentoBox");
        BentoBox.getInstance().getFlagsManager().registerFlag(this.useFlag);
        BentoBox.getInstance().getFlagsManager().registerFlag(this.editNameFlag);
        BentoBox.getInstance().getFlagsManager().registerFlag(this.editSettingsFlag);
        for (Locale objLocale : BentoBox.getInstance().getLocalesManager().getAvailableLocales(true)) {
            BentoBoxLocale locale = (BentoBoxLocale)BentoBox.getInstance().getLocalesManager().getLanguages().get(objLocale);
            if (!locale.contains("protection.flags.USE_ELEVATOR.name")) {
                locale.set("protection.flags.USE_ELEVATOR.name", "Use elevators");
                locale.set("protection.flags.USE_ELEVATOR.description", "Toggle elevators");
            }
            if (!locale.contains("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.name")) {
                locale.set("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.name", "Edit Elevator floor name");
                locale.set("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.description", "Edit the name of the Elevator floor");
            }
            if (locale.contains("protection.flags.EDIT_ELEVATOR_SETTINGS.name")) continue;
            locale.set("protection.flags.EDIT_ELEVATOR_SETTINGS.name", "Edit Elevators settings");
            locale.set("protection.flags.EDIT_ELEVATOR_SETTINGS.description", "Edit the settings of the Elevators");
        }
    }

    @Override
    public void onInit() {
    }

    public boolean isIsland(Location location) {
        return BentoBox.getInstance().getIslands().getIslandAt(location).isPresent();
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.useFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.editNameFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.editSettingsFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        Island island = BentoBox.getInstance().getIslands().getIslandAt(elevator.getLocation()).orElse(null);
        if (island == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(BentoBoxHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GRAY)));
        lore.add(BentoBoxHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.GRAY)));
        lore.add(BentoBoxHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY)));
        lore.add("");
        lore.add(BentoBoxHook.jvmdowngrader$concat$createIconForElevator$4(String.valueOf(ChatColor.GRAY)));
        lore.add(flagEnabled ? BentoBoxHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)) : BentoBoxHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)));
        return ItemStackHelper.createItem(BentoBoxHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)), Material.DIAMOND, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string) {
        return string + "Controls whether island";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string) {
        return string + "guests are blocked from";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string) {
        return string + "using this Elevator.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$4(String string) {
        return string + "Status: ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string, String string2) {
        return string + string2 + "ENABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string, String string2) {
        return string + string2 + "DISABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string, String string2) {
        return string + string2 + "Bento Box";
    }
}

