/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import java.util.Optional;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.models.hooks.ItemsHook;
import me.keehl.elevators.services.ElevatorRecipeService;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public class OraxenHook
extends ItemsHook {
    @Override
    public void onInit() {
        Elevators.log("Oraxen has been hooked. Reloading recipes for Oraxen support");
        Elevators.pushLog();
        ElevatorRecipeService.refreshRecipes();
        Elevators.popLog();
    }

    @Override
    public ItemStack createItemStackFromKey(NamespacedKey key) {
        if (!key.getKey().equalsIgnoreCase("oraxen")) {
            return null;
        }
        Optional itemBuilder = OraxenItems.getOptionalItemById((String)key.getNamespace());
        return itemBuilder.map(ItemBuilder::build).orElse(null);
    }

    @Override
    public NamespacedKey getKeyFromItemStack(ItemStack item) {
        String key = OraxenItems.getIdByItem((ItemStack)item);
        if (key == null) {
            return null;
        }
        return new NamespacedKey(key, "oraxen");
    }
}

