/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.HologramHook;
import me.keehl.elevators.models.hooks.WrappedHologram;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={FancyHologramWrapper.class})
public class FancyHologramsHook
extends HologramHook {
    @Override
    public WrappedHologram createHologram(Elevator elevator, String ... lines) {
        return new FancyHologramWrapper(elevator, lines);
    }

    @Override
    public void onInit() {
    }

    @NestHost(value=FancyHologramsHook.class)
    public static class FancyHologramWrapper
    extends WrappedHologram {
        private final Hologram hologram;

        public FancyHologramWrapper(Elevator elevator, String ... lines) {
            super(elevator);
            TextHologramData textData = new TextHologramData(this.getUUID(), elevator.getLocation().clone());
            Arrays.stream(lines).forEach(arg_0 -> ((TextHologramData)textData).addLine(arg_0));
            textData.setBillboard(Display.Billboard.CENTER);
            textData.setPersistent(false);
            this.hologram = FancyHologramsPlugin.get().getHologramManager().create((HologramData)textData);
            FancyHologramsPlugin.get().getHologramManager().addHologram(this.hologram);
        }

        @Override
        public void addLine(String text) {
            TextHologramData data = (TextHologramData)this.hologram.getData();
            ArrayList<String> hologramText = new ArrayList<String>(data.getText());
            hologramText.add(text);
            data.setText(hologramText);
            this.hologram.queueUpdate();
        }

        @Override
        public void setLines(List<String> text) {
            TextHologramData data = (TextHologramData)this.hologram.getData();
            data.setText(text);
            this.hologram.queueUpdate();
        }

        @Override
        public double getHeight() {
            return ((TextHologramData)this.hologram.getData()).getScale().y();
        }

        @Override
        public void teleportTo(Location location) {
            this.hologram.getData().setLocation(location);
            this.hologram.queueUpdate();
        }

        @Override
        public void onDelete() {
            FancyHologramsPlugin.get().getHologramManager().removeHologram(this.hologram);
        }
    }
}

