/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.ArrayList;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.LandWorld;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LandsHook
extends ProtectionHook {
    private RoleFlag useFlag;
    private RoleFlag settingsFlag;
    private final LandsIntegration lands = LandsIntegration.of((Plugin)Elevators.getInstance());

    public LandsHook() {
        super("Lands");
        this.lands.onLoad(() -> {
            this.useFlag = RoleFlag.of((LandsIntegration)this.lands, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)"elevator_use");
            this.useFlag.setDisplayName("Elevator Use");
            this.useFlag.setDescription("Allows the role to use Elevators in this area");
            this.useFlag.setIcon(ItemStackHelper.createItem(LandsHook.jvmdowngrader$concat$lambda$new$0$1(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)), Material.RED_SHULKER_BOX, 1, MessageHelper.formatLore("Allows the rule to use Elevators in this area", ChatColor.GRAY)));
            this.useFlag.setAlwaysAllowInWilderness(true);
            this.settingsFlag = RoleFlag.of((LandsIntegration)this.lands, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)"elevator_settings");
            this.settingsFlag.setDisplayName("Elevator Manage");
            this.settingsFlag.setDescription("Allows the role to edit Elevators in this area");
            this.settingsFlag.setIcon(ItemStackHelper.createItem(LandsHook.jvmdowngrader$concat$lambda$new$0$2(String.valueOf(ChatColor.GRAY), String.valueOf(ChatColor.BOLD)), Material.LIGHT_GRAY_SHULKER_BOX, 1, MessageHelper.formatLore("Allows the rule to edit Elevators in this area", ChatColor.GRAY)));
        });
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.useFlag, null, sendMessage);
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.settingsFlag, null, sendMessage);
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.settingsFlag, null, sendMessage);
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(LandsHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GRAY)));
        lore.add(LandsHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.GRAY)));
        lore.add(LandsHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY)));
        lore.add("");
        lore.add(LandsHook.jvmdowngrader$concat$createIconForElevator$4(String.valueOf(ChatColor.GRAY)));
        lore.add(flagEnabled ? LandsHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)) : LandsHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)));
        return ItemStackHelper.createItem(LandsHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)), Material.SHIELD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string) {
        return string + "Controls whether this";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string) {
        return string + "elevator will check";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string) {
        return string + "Land flags for use.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$4(String string) {
        return string + "Status: ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string, String string2) {
        return string + string2 + "ENABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string, String string2) {
        return string + string2 + "DISABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string, String string2) {
        return string + string2 + "Lands";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$1(String string, String string2) {
        return string + string2 + "Elevator Use";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$new$0$2(String string, String string2) {
        return string + string2 + "Elevator Manage";
    }
}

