/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.BooleanFlag;
import java.util.ArrayList;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ElevatorEditSettingsFlag.class, ElevatorEditNameFlag.class, ElevatorUseFlag.class})
public class PlotSquaredHook
extends ProtectionHook {
    private final ElevatorUseFlag useFlag = new ElevatorUseFlag(true);
    private final ElevatorEditNameFlag nameFlag;
    private final ElevatorEditSettingsFlag settingsFlag;
    private final PlotAPI api;

    public PlotSquaredHook() {
        super("PlotSquared");
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.useFlag);
        this.nameFlag = new ElevatorEditNameFlag(true);
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.nameFlag);
        this.settingsFlag = new ElevatorEditSettingsFlag(false);
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.settingsFlag);
        this.api = new PlotAPI();
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.useFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.nameFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.settingsFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return null;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GRAY)));
        lore.add(PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.GRAY)));
        lore.add(PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY)));
        lore.add("");
        lore.add(PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$4(String.valueOf(ChatColor.GRAY)));
        lore.add(flagEnabled ? PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)) : PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)));
        return ItemStackHelper.createItem(PlotSquaredHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.AQUA), String.valueOf(ChatColor.BOLD)), Material.DIAMOND_PICKAXE, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string) {
        return string + "Controls whether plot";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string) {
        return string + "guests are blocked from";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string) {
        return string + "using this Elevator.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$4(String string) {
        return string + "Status: ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string, String string2) {
        return string + string2 + "ENABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string, String string2) {
        return string + string2 + "DISABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string, String string2) {
        return string + string2 + "Plot Squared";
    }

    @NestHost(value=PlotSquaredHook.class)
    public static class ElevatorUseFlag
    extends BooleanFlag<ElevatorUseFlag> {
        protected ElevatorUseFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.guest_elevators"));
        }

        protected ElevatorUseFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorUseFlag(aBoolean);
        }
    }

    @NestHost(value=PlotSquaredHook.class)
    public static class ElevatorEditNameFlag
    extends BooleanFlag<ElevatorEditNameFlag> {
        protected ElevatorEditNameFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.name_elevators"));
        }

        protected ElevatorEditNameFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorEditNameFlag(aBoolean);
        }
    }

    @NestHost(value=PlotSquaredHook.class)
    public static class ElevatorEditSettingsFlag
    extends BooleanFlag<ElevatorEditSettingsFlag> {
        protected ElevatorEditSettingsFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.settings_elevators"));
        }

        protected ElevatorEditSettingsFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorEditSettingsFlag(aBoolean);
        }
    }
}

