/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.ArrayList;
import java.util.Optional;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import net.kyori.adventure.key.KeyPattern;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.flag.Flag;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtectHook
extends ProtectionHook {
    private final Flag<Boolean> useFlag;
    private final Flag<Boolean> nameFlag;
    private final Flag<Boolean> settingsFlag;
    private final ProtectPlugin protectPlugin = (ProtectPlugin)Bukkit.getPluginManager().getPlugin("Protect");

    public ProtectHook() {
        super("Protect");
        this.useFlag = this.registerFlag("elevator_use");
        this.nameFlag = this.registerFlag("elevator_rename");
        this.settingsFlag = this.registerFlag("elevator_settings");
    }

    @Override
    public void onInit() {
    }

    private Flag<Boolean> registerFlag(@KeyPattern.Value String flagName) {
        NamespacedKey key = new NamespacedKey((Plugin)Elevators.getInstance(), flagName);
        Optional flagOpt = this.protectPlugin.flagRegistry().getFlag(key);
        return flagOpt.orElseGet(() -> this.protectPlugin.flagRegistry().register((Plugin)Elevators.getInstance(), flagName, (Object)false));
    }

    public void failed(Player player, String message) {
        MessageHelper.sendFormattedMessage((CommandSender)player, ProtectHook.jvmdowngrader$concat$failed$1(message), new Object[0]);
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        Area area = this.protectPlugin.areaProvider().getArea(elevator.getLocation());
        if (((Boolean)area.getFlag(this.useFlag)).booleanValue()) {
            return true;
        }
        boolean permitted = area.isPermitted(player.getUniqueId());
        if (!permitted && sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return permitted;
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        Area area = this.protectPlugin.areaProvider().getArea(elevator.getLocation());
        if (((Boolean)area.getFlag(this.nameFlag)).booleanValue()) {
            return true;
        }
        boolean permitted = area.isPermitted(player.getUniqueId());
        if (!permitted && sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return permitted;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        Area area = this.protectPlugin.areaProvider().getArea(elevator.getLocation());
        if (((Boolean)area.getFlag(this.settingsFlag)).booleanValue()) {
            return true;
        }
        boolean permitted = area.isPermitted(player.getUniqueId());
        if (!permitted && sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return permitted;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(ProtectHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GRAY)));
        lore.add(ProtectHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.GRAY)));
        lore.add(ProtectHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY)));
        lore.add("");
        lore.add(ProtectHook.jvmdowngrader$concat$createIconForElevator$4(String.valueOf(ChatColor.GRAY)));
        lore.add(flagEnabled ? ProtectHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)) : ProtectHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)));
        return ItemStackHelper.createItem(ProtectHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.LIGHT_PURPLE), String.valueOf(ChatColor.BOLD)), Material.SHIELD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    private static /* synthetic */ String jvmdowngrader$concat$failed$1(String string) {
        return "<red><dark_gray>[<dark_red><bold>!</bold></dark_red>]</dark_gray> " + string + "</red>";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string) {
        return string + "Controls whether this";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string) {
        return string + "elevator will check";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string) {
        return string + "Protect flags.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$4(String string) {
        return string + "Status: ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string, String string2) {
        return string + string2 + "ENABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string, String string2) {
        return string + string2 + "DISABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string, String string2) {
        return string + string2 + "Protect";
    }
}

