/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WorldGuardHook
extends ProtectionHook {
    private static StateFlag USE_FLAG;
    private static StateFlag NAME_FLAG;
    private static StateFlag SETTINGS_FLAG;

    public WorldGuardHook() {
        super("WorldGuard");
        USE_FLAG = this.registerFlag("elevators_allow_use");
        NAME_FLAG = this.registerFlag("elevators_allow_rename");
        SETTINGS_FLAG = this.registerFlag("elevators_allow_settings");
    }

    @Override
    public void onInit() {
    }

    private StateFlag registerFlag(String flagName) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            StateFlag flag = new StateFlag("elevators-allow-use", true);
            registry.register((Flag)flag);
            return flag;
        }
        catch (FlagConflictException e) {
            return (StateFlag)registry.get("elevators-allow-use");
        }
    }

    private void formatAndSendDenyMessage(String what, LocalPlayer localPlayer, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = WorldGuard.getInstance().getPlatform().getMatcher().replaceMacros((Actor)localPlayer, message);
        message = CommandUtils.replaceColorMacros((String)message);
        localPlayer.printRaw(message.replace("%what%", what));
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        com.sk89q.worldedit.util.Location location;
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        boolean allowed = query.testState(location = BukkitAdapter.adapt((Location)elevator.getLocation()), localPlayer, new StateFlag[]{USE_FLAG});
        if (!allowed && sendMessage) {
            String message = (String)query.queryValue(location, localPlayer, (Flag)Flags.DENY_MESSAGE);
            this.formatAndSendDenyMessage("use elevators", localPlayer, message);
        }
        return allowed;
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        com.sk89q.worldedit.util.Location location;
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        boolean allowed = query.testState(location = BukkitAdapter.adapt((Location)elevator.getLocation()), localPlayer, new StateFlag[]{NAME_FLAG});
        if (!allowed && sendMessage) {
            String message = (String)query.queryValue(location, localPlayer, (Flag)Flags.DENY_MESSAGE);
            this.formatAndSendDenyMessage("rename elevators", localPlayer, message);
        }
        return allowed;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        com.sk89q.worldedit.util.Location location;
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        boolean allowed = query.testState(location = BukkitAdapter.adapt((Location)elevator.getLocation()), localPlayer, new StateFlag[]{SETTINGS_FLAG});
        if (!allowed && sendMessage) {
            String message = (String)query.queryValue(location, localPlayer, (Flag)Flags.DENY_MESSAGE);
            this.formatAndSendDenyMessage("edit elevator settings", localPlayer, message);
        }
        return allowed;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(WorldGuardHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GRAY)));
        lore.add(WorldGuardHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.GRAY)));
        lore.add(WorldGuardHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY)));
        lore.add("");
        lore.add(WorldGuardHook.jvmdowngrader$concat$createIconForElevator$4(String.valueOf(ChatColor.GRAY)));
        lore.add(flagEnabled ? WorldGuardHook.jvmdowngrader$concat$createIconForElevator$1(String.valueOf(ChatColor.GREEN), String.valueOf(ChatColor.BOLD)) : WorldGuardHook.jvmdowngrader$concat$createIconForElevator$2(String.valueOf(ChatColor.RED), String.valueOf(ChatColor.BOLD)));
        return ItemStackHelper.createItem(WorldGuardHook.jvmdowngrader$concat$createIconForElevator$3(String.valueOf(ChatColor.GRAY), String.valueOf(ChatColor.BOLD)), Material.LEAD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string) {
        return string + "Controls whether this";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string) {
        return string + "elevator will check";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string) {
        return string + "World Guard flags.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$4(String string) {
        return string + "Status: ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$1(String string, String string2) {
        return string + string2 + "ENABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$2(String string, String string2) {
        return string + string2 + "DISABLED";
    }

    private static /* synthetic */ String jvmdowngrader$concat$createIconForElevator$3(String string, String string2) {
        return string + string2 + "World Guard";
    }
}

