/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui.version;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import me.keehl.elevators.util.signgui.SignEditor;
import me.keehl.elevators.util.signgui.SignGUIChannelHandler;
import me.keehl.elevators.util.signgui.version.VersionWrapper;
import net.minecraft.server.v1_8_R1.BlockPosition;
import net.minecraft.server.v1_8_R1.ChatComponentText;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.IChatBaseComponent;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayInUpdateSign;
import net.minecraft.server.v1_8_R1.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_8_R1.PlayerConnection;
import net.minecraft.server.v1_8_R1.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class Wrapper1_8_R1
implements VersionWrapper {
    @Override
    public Material getDefaultType() {
        return Material.SIGN_POST;
    }

    @Override
    public List<Material> getSignTypes() {
        return Arrays.asList(Material.SIGN_POST);
    }

    @Override
    public void openSignEditor(final Player player, String[] lines, Object[] adventureLines, Material type, DyeColor color, boolean glow, Location signLoc, final BiConsumer<SignEditor, String[]> onFinish) throws NoSuchFieldException, IllegalAccessException {
        EntityPlayer p = ((CraftPlayer)player).getHandle();
        PlayerConnection conn = p.playerConnection;
        Location loc = signLoc != null ? signLoc : this.getDefaultLocation(player);
        final BlockPosition pos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        TileEntitySign sign = new TileEntitySign();
        sign.a(pos);
        for (int i = 0; i < lines.length; ++i) {
            sign.lines[i] = new ChatComponentText(lines[i] != null ? lines[i] : "");
        }
        Field field = conn.networkManager.getClass().getDeclaredField("i");
        field.setAccessible(true);
        ChannelPipeline pipeline = ((Channel)field.get(conn.networkManager)).pipeline();
        field.setAccessible(false);
        boolean schedule = false;
        if (pipeline.names().contains("SignGUI")) {
            ChannelHandler handler = pipeline.get("SignGUI");
            if (handler instanceof SignGUIChannelHandler) {
                SignGUIChannelHandler signGUIHandler = (SignGUIChannelHandler)handler;
                signGUIHandler.close();
                schedule = signGUIHandler.getBlockPosition().equals(pos);
            }
            if (pipeline.names().contains("SignGUI")) {
                pipeline.remove("SignGUI");
            }
        }
        Runnable runnable = () -> {
            player.sendBlockChange(loc, type, (byte)0);
            conn.sendPacket(sign.getUpdatePacket());
            conn.sendPacket((Packet)new PacketPlayOutOpenSignEditor(pos));
            final SignEditor signEditor = new SignEditor(sign, loc, pos, pipeline);
            pipeline.addAfter("decoder", "SignGUI", (ChannelHandler)new SignGUIChannelHandler<Packet>(){

                @Override
                public Object getBlockPosition() {
                    return pos;
                }

                @Override
                public void close() {
                    Wrapper1_8_R1.this.closeSignEditor(player, signEditor);
                }

                protected void decode(ChannelHandlerContext chc, Packet packet, List<Object> out) {
                    try {
                        PacketPlayInUpdateSign updateSign;
                        if (packet instanceof PacketPlayInUpdateSign && (updateSign = (PacketPlayInUpdateSign)packet).a().equals((Object)pos)) {
                            onFinish.accept(signEditor, (String[])Arrays.stream(updateSign.b()).map(IChatBaseComponent::getText).toArray(String[]::new));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    out.add(packet);
                }
            });
        };
        if (schedule) {
            SCHEDULER.schedule(runnable, 200L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public void displayNewLines(Player player, SignEditor signEditor, String[] lines, Object[] adventureLines) {
        TileEntitySign sign = (TileEntitySign)signEditor.getSign();
        for (int i = 0; i < lines.length; ++i) {
            sign.lines[i] = new ChatComponentText(lines[i] != null ? lines[i] : "");
        }
        PlayerConnection conn = ((CraftPlayer)player).getHandle().playerConnection;
        conn.sendPacket(sign.getUpdatePacket());
        conn.sendPacket((Packet)new PacketPlayOutOpenSignEditor((BlockPosition)signEditor.getBlockPosition()));
    }

    @Override
    public void closeSignEditor(Player player, SignEditor signEditor) {
        Location loc = signEditor.getLocation();
        signEditor.getPipeline().remove("SignGUI");
        player.sendBlockChange(loc, loc.getBlock().getType(), loc.getBlock().getData());
    }
}

