/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.ArrayList;
import java.util.function.Supplier;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GriefPreventionHook
extends ProtectionHook {
    private final GriefPrevention griefPrevention = (GriefPrevention)Bukkit.getPluginManager().getPlugin("GriefPrevention");

    public GriefPreventionHook() {
        super("GriefPrevention");
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        if (this.griefPrevention == null) {
            return false;
        }
        PlayerData playerData = this.griefPrevention.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.griefPrevention.dataStore.getClaimAt(elevator.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            return true;
        }
        Supplier message = claim.checkPermission(player, ClaimPermission.Access, null);
        if (message != null) {
            if (sendMessage) {
                player.sendMessage(String.valueOf(ChatColor.RED) + (String)message.get());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        if (this.griefPrevention == null) {
            return false;
        }
        PlayerData playerData = this.griefPrevention.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.griefPrevention.dataStore.getClaimAt(elevator.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            return true;
        }
        Supplier message = claim.checkPermission(player, ClaimPermission.Edit, null);
        if (message != null) {
            if (sendMessage) {
                player.sendMessage(String.valueOf(ChatColor.RED) + (String)message.get());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        if (this.griefPrevention == null) {
            return false;
        }
        PlayerData playerData = this.griefPrevention.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.griefPrevention.dataStore.getClaimAt(elevator.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            return true;
        }
        Supplier message = claim.checkPermission(player, ClaimPermission.Manage, null);
        return message == null;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        if (this.griefPrevention == null) {
            return null;
        }
        PlayerData playerData = this.griefPrevention.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.griefPrevention.dataStore.getClaimAt(elevator.getLocation(), false, playerData.lastClaim);
        if (claim == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether claim");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "Grief Prevention", Material.GOLDEN_SWORD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

