/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import br.net.fabiozumbi12.RedProtect.Bukkit.API.RedProtectAPI;
import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import java.util.ArrayList;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.hooks.ProtectionHook;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RedProtectHook
extends ProtectionHook {
    private final RedProtectAPI redProtect = RedProtect.get().getAPI();
    private final String flagName = "outsiders_use_elevators";
    private final String nameFlagName = "edit_name_elevators";
    private final String settingsFlagName = "edit_settings_elevators";

    public RedProtectHook() {
        super("RedProtect");
        this.redProtect.addFlag(this.flagName, true, false);
        this.redProtect.addFlag(this.nameFlagName, true, false);
        this.redProtect.addFlag(this.settingsFlagName, false, false);
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, Elevator elevator, boolean sendMessage) {
        Region region = this.redProtect.getRegion(elevator.getShulkerBox().getLocation());
        if (region == null || region.getFlagBool(this.flagName)) {
            return true;
        }
        if (region.isLeader(player) || region.isAdmin(player) || region.isMember(player) || player.hasPermission("redprotect.flag.bypass." + this.flagName)) {
            return true;
        }
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can't interact with this here!");
        }
        return false;
    }

    @Override
    public boolean canEditName(Player player, Elevator elevator, boolean sendMessage) {
        Region region = this.redProtect.getRegion(elevator.getShulkerBox().getLocation());
        if (region == null || region.getFlagBool(this.nameFlagName)) {
            return true;
        }
        if (region.isLeader(player) || region.isAdmin(player) || region.isMember(player) || player.hasPermission("redprotect.flag.bypass." + this.nameFlagName)) {
            return true;
        }
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can't interact with this here!");
        }
        return false;
    }

    @Override
    public boolean canEditSettings(Player player, Elevator elevator, boolean sendMessage) {
        Region region = this.redProtect.getRegion(elevator.getShulkerBox().getLocation());
        if (region == null || region.getFlagBool(this.settingsFlagName)) {
            return true;
        }
        if (region.isLeader(player) || region.isAdmin(player) || player.hasPermission("redprotect.flag.bypass." + this.settingsFlagName)) {
            return true;
        }
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can't interact with this here!");
        }
        return false;
    }

    @Override
    public ItemStack createIconForElevator(Player player, Elevator elevator) {
        Region region = this.redProtect.getRegion(elevator.getLocation());
        if (region == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether claim");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Red Protect", Material.RED_DYE, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, Elevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

