/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.services.ElevatorHooks;
import me.keehl.elevators.util.bstats.bukkit.Metrics;
import me.keehl.elevators.util.folialib.FoliaLib;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorsPlugin
extends JavaPlugin {
    private static final String LIGHT_GRAY = "\u001b[38;5;250m";
    private static final String YELLOW = "\u001b[33m";
    private static final String RED = "\u001b[31m";
    private static final String RESET = "\u001b[0m";
    private static final String BOLD = "\u001b[1m";
    private Metrics metrics;
    private final FoliaLib foliaLib = new FoliaLib((Plugin)this);

    private void printBanner() {
        String version = "Version: " + this.getDescription().getVersion();
        String server = this.foliaLib.getImplType().name() + " " + Bukkit.getServer().getVersion();
        String java = "Java Version:" + System.getProperty("java.version");
        String operatingSystem = "OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version");
        Bukkit.getLogger().info("\n\u001b[31m  _____ _               _                  \n\u001b[31m | ____| | _____   ___ | |_ ___  _ __ ___  \u001b[1m\u001b[38;5;250m    " + version + "\n\u001b[31m |  _| | |/ _ \\ \\ / / \\| __/ _ \\| '__/ __| \u001b[1m\u001b[38;5;250m    " + server + "\n\u001b[31m | |___| |  __/\\ V / \u039b \\ || (_) | |  \\__ \\ \u001b[1m\u001b[38;5;250m    " + java + "\n\u001b[31m |_____|_|\\___| \\_/_/ \\_\\__\\___/|_|  |___/ \u001b[1m\u001b[38;5;250m    " + operatingSystem + "\n\u001b[31m                                            \u001b[0m");
    }

    public void onLoad() {
        ElevatorHooks.buildHooksEarly(this.foliaLib);
    }

    public void onEnable() {
        this.getLogger().setFilter(new ElevatorLoggingFilter(this.getLogger().getFilter()));
        this.printBanner();
        Elevators.pushAndHoldLog();
        Elevators.pushAndHoldLog();
        this.metrics = new Metrics((Plugin)this, 8026);
        Elevators.popLog(logData -> Elevators.log("Metrics enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        Elevators.enable(this, this.foliaLib);
        ElevatorHooks.buildHooks(this.foliaLib);
        Elevators.popLog(logData -> Elevators.log("Plugin enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.getLogger().info("Disabling metrics");
            this.metrics.shutdown();
        }
        Elevators.disable();
    }

    public static class ElevatorLoggingFilter
    implements Filter {
        private final Filter delegate;

        public ElevatorLoggingFilter(Filter delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            record.setLoggerName("\u001b[1m\u001b[31mElevators\u001b[0m");
            Object message = record.getMessage();
            if (record.getLevel() == Level.INFO) {
                message = ElevatorsPlugin.LIGHT_GRAY + record.getMessage();
            }
            message = ((String)message).replace("\u00a7e", ElevatorsPlugin.YELLOW);
            record.setMessage((String)message + ElevatorsPlugin.RESET);
            return this.delegate == null || this.delegate.isLoggable(record);
        }
    }
}

