/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.hooks.BentoBoxHook;
import me.keehl.elevators.services.hooks.DecentHologramsHook;
import me.keehl.elevators.services.hooks.FancyHologramsHook;
import me.keehl.elevators.services.hooks.GriefDefenderHook;
import me.keehl.elevators.services.hooks.GriefPreventionHook;
import me.keehl.elevators.services.hooks.ItemsAdderHook;
import me.keehl.elevators.services.hooks.LandsHook;
import me.keehl.elevators.services.hooks.NexoHook;
import me.keehl.elevators.services.hooks.OraxenHook;
import me.keehl.elevators.services.hooks.PaperDialogHook;
import me.keehl.elevators.services.hooks.PlaceholderAPIHook;
import me.keehl.elevators.services.hooks.PlotSquaredHook;
import me.keehl.elevators.services.hooks.ProtectHook;
import me.keehl.elevators.services.hooks.RedProtectHook;
import me.keehl.elevators.services.hooks.SpigotDialogHook;
import me.keehl.elevators.services.hooks.SuperiorSkyblock2Hook;
import me.keehl.elevators.util.folialib.FoliaLib;
import org.bukkit.ChatColor;

public class ElevatorHooks {
    public static void buildHooksEarly(FoliaLib foliaLibs) {
        Elevators.pushAndHoldLog();
        ElevatorHookService.registerHook("Protect", ProtectHook.class, false);
        Elevators.popLog(logData -> Elevators.log("Early Hooks built. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public static void buildHooks(FoliaLib foliaLibs) {
        Elevators.pushAndHoldLog();
        ElevatorHookService.registerHook("GriefPrevention", GriefPreventionHook.class);
        ElevatorHookService.registerHook("GriefDefender", GriefDefenderHook.class);
        ElevatorHookService.registerHook("RedProtect", RedProtectHook.class);
        ElevatorHookService.registerHook("PlotSquared", PlotSquaredHook.class);
        ElevatorHookService.registerHook("BentoBox", BentoBoxHook.class);
        ElevatorHookService.registerHook("SuperiorSkyblock2", SuperiorSkyblock2Hook.class, false);
        ElevatorHookService.registerHook("Lands", LandsHook.class, false);
        ElevatorHookService.registerHook("DecentHolograms", DecentHologramsHook.class);
        ElevatorHookService.registerHook("FancyHolograms", FancyHologramsHook.class);
        ElevatorHookService.registerHook("PlaceholderAPI", PlaceholderAPIHook.class);
        ElevatorHookService.registerHook("ItemsAdder", ItemsAdderHook.class);
        ElevatorHookService.registerHook("Oraxen", OraxenHook.class);
        ElevatorHookService.registerHook("Nexo", NexoHook.class);
        if (VersionHelper.doesVersionSupportDialogs()) {
            if (foliaLibs.isPaper()) {
                ElevatorHookService.setDialogHook(new PaperDialogHook());
            } else if (foliaLibs.isSpigot()) {
                ElevatorHookService.setDialogHook(new SpigotDialogHook());
            }
        }
        Elevators.popLog(logData -> Elevators.log("Hooks built. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        if (VersionHelper.doesVersionSupportAutoCrafters()) {
            try {
                Class<?> clazz = Class.forName("me.keehl.elevators.services.listeners.AutoCrafterListener");
                Method method = clazz.getMethod("setupListener", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

