/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.services.hooks.UniDialogHook;
import me.keehl.elevators.util.projectunified.unidialog.paper.PaperDialogManager;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperMultiActionDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.opener.PaperDialogOpener;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PaperDialogHook
extends UniDialogHook {
    private final PaperDialogManager dialogManager = new PaperDialogManager((Plugin)Elevators.getInstance());

    @Override
    public void onInit() {
        this.dialogManager.register();
        this.dialogManager.registerCustomAction("ele-hook-confirm", this::onConfirm);
        this.dialogManager.registerCustomAction("ele-hook-cancel", this::onCancel);
        this.dialogManager.registerCustomAction("ele-hook-reset", this::onReset);
    }

    @Override
    public void clearDialog(UUID owner) {
        this.dialogManager.clearDialog(owner);
    }

    @Override
    public void createStringInputDialog(Player player, Function<String, Boolean> validationFunction, Consumer<String> resultConsumer, Runnable onCancel, String title, boolean allowReset, String message, String defaultMessage, String inputLabel) {
        PaperMultiActionDialog dialog = this.dialogManager.createMultiActionDialog();
        dialog.title((Component)Component.text((String)title));
        dialog.body(body -> body.text().text((Component)Component.text((String)message)));
        dialog.input("input", inputBuilder -> inputBuilder.textInput().label((Component)Component.text((String)inputLabel)).initial(defaultMessage));
        dialog.action(action -> action.label((Component)Component.text((String)"Confirm")).dynamicCustom("ele-hook-confirm"));
        if (allowReset) {
            dialog.action(action -> action.label((Component)Component.text((String)"Cancel")).dynamicCustom("ele-hook-reset"));
        }
        dialog.exitAction(action -> action.label((Component)Component.text((String)"Cancel")).dynamicCustom("ele-hook-cancel"));
        PaperDialogOpener dialogOpener = dialog.opener();
        UniDialogHook.ElevatorDialogData data = new UniDialogHook.ElevatorDialogData(validationFunction, resultConsumer, onCancel, dialogOpener);
        this.userDialogData.put(player.getUniqueId(), data);
        dialogOpener.open(player.getUniqueId());
    }
}

