/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.services.hooks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.models.hooks.DialogHook;
import me.keehl.elevators.util.projectunified.unidialog.core.opener.DialogOpener;
import me.keehl.elevators.util.projectunified.unidialog.core.payload.DialogPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.chat.TextComponent;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;

public abstract class UniDialogHook
extends DialogHook {
    protected final Map<UUID, ElevatorDialogData> userDialogData = new HashMap<UUID, ElevatorDialogData>();
    protected static final String CONFIRM_KEY = "ele-hook-confirm";
    protected static final String CANCEL_KEY = "ele-hook-cancel";
    protected static final String RESET_KEY = "ele-hook-reset";

    public abstract void clearDialog(UUID var1);

    void onConfirm(DialogPayload payload) {
        boolean valid;
        ElevatorDialogData data = this.userDialogData.getOrDefault(payload.owner(), null);
        if (data == null) {
            return;
        }
        String value = payload.textValue("input");
        if (value == null || value.isBlank()) {
            value = "";
        }
        try {
            valid = data.validationFunction.apply(value);
        }
        catch (Exception ex) {
            valid = false;
            Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to validate dialog input. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
        }
        if (!valid) {
            data.dialogOpener.open(payload.owner());
            return;
        }
        this.clearDialog(payload.owner());
        try {
            data.resultConsumer.accept(value);
        }
        catch (Exception ex) {
            Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to execute dialog input consumer. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
        }
        this.userDialogData.remove(payload.owner());
    }

    void onCancel(DialogPayload payload) {
        ElevatorDialogData data = this.userDialogData.getOrDefault(payload.owner(), null);
        if (data == null) {
            return;
        }
        this.clearDialog(payload.owner());
        data.onCancel.run();
        this.userDialogData.remove(payload.owner());
    }

    void onReset(DialogPayload payload) {
        ElevatorDialogData data = this.userDialogData.getOrDefault(payload.owner(), null);
        if (data == null) {
            return;
        }
        this.clearDialog(payload.owner());
        try {
            data.resultConsumer.accept(null);
        }
        catch (Exception ex) {
            Elevators.getElevatorsLogger().log(Level.SEVERE, "Failed to execute dialog input consumer. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n" + ResourceHelper.cleanTrace(ex));
        }
        this.userDialogData.remove(payload.owner());
    }

    TextComponent baseComponentFromAdventure(Component adventureComponent) {
        return new TextComponent(BungeeComponentSerializer.get().serialize(adventureComponent));
    }

    @RecordComponents(value={@RecordComponents.Value(name="validationFunction", type=Function.class), @RecordComponents.Value(name="resultConsumer", type=Consumer.class), @RecordComponents.Value(name="onCancel", type=Runnable.class), @RecordComponents.Value(name="dialogOpener", type=DialogOpener.class)})
    public static final class ElevatorDialogData
    extends J_L_Record {
        private final Function<String, Boolean> validationFunction;
        private final Consumer<String> resultConsumer;
        private final Runnable onCancel;
        private final DialogOpener dialogOpener;

        public ElevatorDialogData(Function<String, Boolean> validationFunction, Consumer<String> resultConsumer, Runnable onCancel, DialogOpener dialogOpener) {
            this.validationFunction = validationFunction;
            this.resultConsumer = resultConsumer;
            this.onCancel = onCancel;
            this.dialogOpener = dialogOpener;
        }

        public final String toString() {
            return ElevatorDialogData.jvmdowngrader$toString$toString(this);
        }

        public final int hashCode() {
            return ElevatorDialogData.jvmdowngrader$hashCode$hashCode(this);
        }

        public final boolean equals(Object o) {
            return ElevatorDialogData.jvmdowngrader$equals$equals(this, o);
        }

        public Function<String, Boolean> validationFunction() {
            return this.validationFunction;
        }

        public Consumer<String> resultConsumer() {
            return this.resultConsumer;
        }

        public Runnable onCancel() {
            return this.onCancel;
        }

        public DialogOpener dialogOpener() {
            return this.dialogOpener;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(ElevatorDialogData elevatorDialogData) {
            ElevatorDialogData elevatorDialogData2 = elevatorDialogData;
            return "UniDialogHook$ElevatorDialogData[" + "validationFunction=" + elevatorDialogData.validationFunction + ", " + "resultConsumer=" + elevatorDialogData.resultConsumer + ", " + "onCancel=" + elevatorDialogData.onCancel + ", " + "dialogOpener=" + elevatorDialogData.dialogOpener + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(ElevatorDialogData elevatorDialogData) {
            Object[] objectArray = new Object[]{elevatorDialogData.validationFunction, elevatorDialogData.resultConsumer, elevatorDialogData.onCancel, elevatorDialogData.dialogOpener};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(ElevatorDialogData elevatorDialogData, Object object) {
            if (elevatorDialogData == object) {
                return true;
            }
            if (object != null && object instanceof ElevatorDialogData) {
                ElevatorDialogData elevatorDialogData2 = (ElevatorDialogData)((Object)object);
                if (Objects.equals(elevatorDialogData.validationFunction, elevatorDialogData2.validationFunction) && Objects.equals(elevatorDialogData.resultConsumer, elevatorDialogData2.resultConsumer) && Objects.equals(elevatorDialogData.onCancel, elevatorDialogData2.onCancel) && Objects.equals(elevatorDialogData.dialogOpener, elevatorDialogData2.dialogOpener)) {
                    return true;
                }
            }
            return false;
        }
    }
}

