/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.projectunified.unidialog.paper;

import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerGameConnection;
import io.papermc.paper.event.player.PlayerCustomClickEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.elevators.util.projectunified.unidialog.core.DialogManager;
import me.keehl.elevators.util.projectunified.unidialog.core.payload.DialogPayload;
import me.keehl.elevators.util.projectunified.unidialog.paper.action.PaperDialogActionBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.body.PaperDialogBodyBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperConfirmationDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperDialogListDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperMultiActionDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperNoticeDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.dialog.PaperServerLinksDialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.input.PaperDialogInputBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.payload.PaperDialogPayload;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PaperDialogManager
implements DialogManager<ItemStack, PaperDialogBodyBuilder, PaperDialogInputBuilder, PaperDialog<?>, PaperDialogActionBuilder>,
Listener {
    private final Plugin plugin;
    private final String defaultNamespace;
    private final Function<String, Component> componentDeserializer;
    private final Map<Key, Consumer<DialogPayload>> customActions = new HashMap<Key, Consumer<DialogPayload>>();

    public PaperDialogManager(Plugin plugin, String defaultNamespace, Function<String, Component> componentDeserializer) {
        this.plugin = plugin;
        this.defaultNamespace = defaultNamespace;
        this.componentDeserializer = componentDeserializer;
    }

    public PaperDialogManager(Plugin plugin, String defaultNamespace) {
        this(plugin, defaultNamespace, arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).deserialize(arg_0));
    }

    public PaperDialogManager(Plugin plugin, Function<String, Component> componentDeserializer) {
        this(plugin, plugin.getName().replace("[^a-zA-Z0-9]", "_").toLowerCase(Locale.ROOT), componentDeserializer);
    }

    public PaperDialogManager(Plugin plugin) {
        this(plugin, arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).deserialize(arg_0));
    }

    @Override
    public PaperConfirmationDialog createConfirmationDialog() {
        return new PaperConfirmationDialog(this.defaultNamespace, this.componentDeserializer);
    }

    @Override
    public PaperMultiActionDialog createMultiActionDialog() {
        return new PaperMultiActionDialog(this.defaultNamespace, this.componentDeserializer);
    }

    @Override
    public PaperServerLinksDialog createServerLinksDialog() {
        return new PaperServerLinksDialog(this.defaultNamespace, this.componentDeserializer);
    }

    @Override
    public PaperNoticeDialog createNoticeDialog() {
        return new PaperNoticeDialog(this.defaultNamespace, this.componentDeserializer);
    }

    @Override
    public PaperDialogListDialog createDialogListDialog() {
        return new PaperDialogListDialog(this.defaultNamespace, this.componentDeserializer);
    }

    @Override
    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        this.unregisterAllCustomActions();
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        UUID uuid;
        Key key = event.getIdentifier();
        Consumer<DialogPayload> action = this.customActions.get(key);
        if (action == null) {
            return;
        }
        PlayerCommonConnection playerCommonConnection = event.getCommonConnection();
        Objects.requireNonNull(playerCommonConnection);
        PlayerCommonConnection playerCommonConnection2 = playerCommonConnection;
        int n = 0;
        switch (PaperDialogManager.jvmdowngrader$switch$onCustomClick$0(playerCommonConnection2, n)) {
            case 0: {
                PlayerGameConnection pgc = (PlayerGameConnection)playerCommonConnection2;
                UUID uUID = pgc.getPlayer().getUniqueId();
                break;
            }
            case 1: {
                PlayerConfigurationConnection pcc = (PlayerConfigurationConnection)playerCommonConnection2;
                UUID uUID = pcc.getProfile().getUniqueId();
                break;
            }
            default: {
                UUID uUID = uuid = null;
            }
        }
        if (uuid == null) {
            return;
        }
        action.accept(new PaperDialogPayload(uuid, event.getDialogResponseView()));
    }

    @Override
    public void unregisterCustomAction(String id) {
        this.unregisterCustomAction(this.defaultNamespace, id);
    }

    @Override
    public void unregisterCustomAction(String namespace, String id) {
        this.customActions.remove(Key.key((String)namespace, (String)id));
    }

    @Override
    public void unregisterAllCustomActions() {
        this.customActions.clear();
    }

    @Override
    public void registerCustomAction(String id, Consumer<DialogPayload> action) {
        this.registerCustomAction(this.defaultNamespace, id, action);
    }

    @Override
    public void registerCustomAction(String namespace, String id, Consumer<DialogPayload> action) {
        this.customActions.put(Key.key((String)namespace, (String)id), action);
    }

    @Override
    public boolean clearDialog(UUID uuid) {
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        try {
            player.closeDialog();
        }
        catch (Throwable e) {
            player.closeInventory();
        }
        return true;
    }

    private static /* synthetic */ int jvmdowngrader$switch$onCustomClick$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 2) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bounds for length " + 2);
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof PlayerGameConnection) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof PlayerConfigurationConnection) {
                        n2 = 1;
                        break;
                    }
                }
                default: {
                    n2 = 2;
                }
            }
        }
        return n2;
    }
}

