/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.projectunified.unidialog.paper.dialog;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.event.RegistryComposeEvent;
import io.papermc.paper.registry.event.WritableRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import me.keehl.elevators.util.projectunified.unidialog.adventure.dialog.AdventureDialog;
import me.keehl.elevators.util.projectunified.unidialog.core.dialog.Dialog;
import me.keehl.elevators.util.projectunified.unidialog.paper.action.PaperDialogActionBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.body.PaperDialogBodyBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.input.PaperDialogInputBuilder;
import me.keehl.elevators.util.projectunified.unidialog.paper.opener.PaperDialogOpener;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;

public abstract class PaperDialog<T extends PaperDialog<T>>
implements AdventureDialog<ItemStack, PaperDialogBodyBuilder, PaperDialogInputBuilder, T> {
    private final String defaultNamespace;
    private final Function<String, Component> componentDeserializer;
    private Component title;
    @Nullable
    private Component externalTitle;
    private boolean canCloseWithEscape = true;
    private boolean pause = false;
    private DialogBase.DialogAfterAction afterAction;
    private List<DialogBody> body;
    private List<DialogInput> input;

    protected PaperDialog(String defaultNamespace, Function<String, Component> componentDeserializer) {
        this.defaultNamespace = defaultNamespace;
        this.componentDeserializer = componentDeserializer;
    }

    @Override
    public T title(Component title) {
        this.title = title;
        return (T)this;
    }

    @Override
    public T externalTitle(@Nullable Component externalTitle) {
        this.externalTitle = externalTitle;
        return (T)this;
    }

    @Override
    public Function<String, Component> getComponentDeserializer() {
        return this.componentDeserializer;
    }

    @Override
    public T canCloseWithEscape(boolean canCloseWithEscape) {
        this.canCloseWithEscape = canCloseWithEscape;
        return (T)this;
    }

    @Override
    public T pause(boolean pause) {
        this.pause = pause;
        return (T)this;
    }

    @Override
    public T afterAction(Dialog.AfterAction afterAction) {
        DialogBase.DialogAfterAction dialogAfterAction;
        switch (afterAction) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case CLOSE: {
                dialogAfterAction = DialogBase.DialogAfterAction.CLOSE;
                break;
            }
            case WAIT_FOR_RESPONSE: {
                dialogAfterAction = DialogBase.DialogAfterAction.WAIT_FOR_RESPONSE;
                break;
            }
            case NONE: {
                dialogAfterAction = DialogBase.DialogAfterAction.NONE;
            }
        }
        this.afterAction = dialogAfterAction;
        return (T)this;
    }

    @Override
    public T body(Consumer<PaperDialogBodyBuilder> bodyBuilder) {
        if (this.body == null) {
            this.body = new ArrayList<DialogBody>();
        }
        PaperDialogBodyBuilder builder = new PaperDialogBodyBuilder(this.componentDeserializer);
        bodyBuilder.accept(builder);
        this.body.add(builder.getDialogBody());
        return (T)this;
    }

    @Override
    public T input(String key, Consumer<PaperDialogInputBuilder> inputBuilder) {
        if (this.input == null) {
            this.input = new ArrayList<DialogInput>();
        }
        PaperDialogInputBuilder builder = new PaperDialogInputBuilder(key, this.componentDeserializer);
        inputBuilder.accept(builder);
        this.input.add(builder.getDialogInput());
        return (T)this;
    }

    protected ActionButton getAction(Consumer<PaperDialogActionBuilder> actionBuilder) {
        PaperDialogActionBuilder builder = new PaperDialogActionBuilder(this.defaultNamespace, this.componentDeserializer);
        actionBuilder.accept(builder);
        return builder.getAction();
    }

    protected abstract DialogType getDialogType();

    private DialogBase getDialogBase() {
        return DialogBase.create((Component)(this.title != null ? this.title : Component.text((String)"Dialog")), (Component)this.externalTitle, (boolean)this.canCloseWithEscape, (boolean)this.pause, (DialogBase.DialogAfterAction)this.afterAction, this.body != null ? this.body : Collections.emptyList(), this.input != null ? this.input : Collections.emptyList());
    }

    public final Consumer<DialogRegistryEntry.Builder> getDialogBuilder() {
        return builder -> builder.base(this.getDialogBase()).type(this.getDialogType());
    }

    public final Dialog getDialog() {
        return Dialog.create(factory -> this.getDialogBuilder().accept((DialogRegistryEntry.Builder)factory.empty()));
    }

    public final void register(Key key, WritableRegistry<Dialog, DialogRegistryEntry.Builder> registry) {
        registry.register(TypedKey.create((RegistryKey)RegistryKey.DIALOG, (Key)key), this.getDialogBuilder());
    }

    public final void register(Key key, RegistryComposeEvent<Dialog, DialogRegistryEntry.Builder> event) {
        this.register(key, (WritableRegistry<Dialog, DialogRegistryEntry.Builder>)event.registry());
    }

    public final void register(String namespace, String dialogId, WritableRegistry<Dialog, DialogRegistryEntry.Builder> registry) {
        Key key = Key.key((String)namespace, (String)dialogId);
        this.register(key, registry);
    }

    public final void register(String namespace, String dialogId, RegistryComposeEvent<Dialog, DialogRegistryEntry.Builder> event) {
        Key key = Key.key((String)namespace, (String)dialogId);
        this.register(key, event);
    }

    public final void register(String dialogId, WritableRegistry<Dialog, DialogRegistryEntry.Builder> registry) {
        Key key = Key.key((String)this.defaultNamespace, (String)dialogId);
        this.register(key, registry);
    }

    public final void register(String dialogId, RegistryComposeEvent<Dialog, DialogRegistryEntry.Builder> event) {
        Key key = Key.key((String)this.defaultNamespace, (String)dialogId);
        this.register(key, event);
    }

    @Override
    public PaperDialogOpener opener() {
        return new PaperDialogOpener(this.getDialog());
    }
}

