/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.projectunified.unidialog.spigot;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.action.BungeeDialogActionBuilder;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.body.BungeeDialogBodyBuilder;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeConfirmationDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeDialogListDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeMultiActionDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeNoticeDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.dialog.BungeeServerLinksDialog;
import me.keehl.elevators.util.projectunified.unidialog.bungeecord.input.BungeeDialogInputBuilder;
import me.keehl.elevators.util.projectunified.unidialog.core.DialogManager;
import me.keehl.elevators.util.projectunified.unidialog.core.payload.DialogPayload;
import me.keehl.elevators.util.projectunified.unidialog.spigot.opener.SpigotDialogOpener;
import me.keehl.elevators.util.projectunified.unidialog.spigot.payload.SpigotDialogPayload;
import net.md_5.bungee.api.dialog.Dialog;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCustomClickEvent;
import org.bukkit.plugin.Plugin;

public class SpigotDialogManager
implements DialogManager<Object, BungeeDialogBodyBuilder, BungeeDialogInputBuilder, BungeeDialog<?, ?>, BungeeDialogActionBuilder>,
Listener {
    private final Plugin plugin;
    private final String defaultNamespace;
    private final Map<NamespacedKey, Consumer<DialogPayload>> customActions = new HashMap<NamespacedKey, Consumer<DialogPayload>>();

    public SpigotDialogManager(Plugin plugin, String defaultNamespace) {
        this.plugin = plugin;
        this.defaultNamespace = defaultNamespace;
    }

    public SpigotDialogManager(Plugin plugin) {
        this(plugin, plugin.getName().replace("[^a-zA-Z0-9]", "_").toLowerCase(Locale.ROOT));
    }

    private SpigotDialogOpener getDialogOpener(Dialog dialog) {
        return new SpigotDialogOpener(dialog);
    }

    @Override
    public BungeeConfirmationDialog<SpigotDialogOpener> createConfirmationDialog() {
        return new BungeeConfirmationDialog<SpigotDialogOpener>(this.defaultNamespace, this::getDialogOpener);
    }

    @Override
    public BungeeMultiActionDialog<SpigotDialogOpener> createMultiActionDialog() {
        return new BungeeMultiActionDialog<SpigotDialogOpener>(this.defaultNamespace, this::getDialogOpener);
    }

    @Override
    public BungeeServerLinksDialog<SpigotDialogOpener> createServerLinksDialog() {
        return new BungeeServerLinksDialog<SpigotDialogOpener>(this.defaultNamespace, this::getDialogOpener);
    }

    @Override
    public BungeeNoticeDialog<SpigotDialogOpener> createNoticeDialog() {
        return new BungeeNoticeDialog<SpigotDialogOpener>(this.defaultNamespace, this::getDialogOpener);
    }

    @Override
    public BungeeDialogListDialog<SpigotDialogOpener> createDialogListDialog() {
        return new BungeeDialogListDialog<SpigotDialogOpener>(this.defaultNamespace, this::getDialogOpener);
    }

    @Override
    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
        this.unregisterAllCustomActions();
    }

    @EventHandler
    public void onCustomClick(PlayerCustomClickEvent event) {
        NamespacedKey key = event.getId();
        Consumer<DialogPayload> action = this.customActions.get(key);
        if (action == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        action.accept(new SpigotDialogPayload(uuid, event.getData()));
    }

    @Override
    public void registerCustomAction(String id, Consumer<DialogPayload> action) {
        this.registerCustomAction(this.defaultNamespace, id, action);
    }

    @Override
    public void registerCustomAction(String namespace, String id, Consumer<DialogPayload> action) {
        this.customActions.put(new NamespacedKey(namespace, id), action);
    }

    @Override
    public void unregisterCustomAction(String id) {
        this.unregisterCustomAction(this.defaultNamespace, id);
    }

    @Override
    public void unregisterCustomAction(String namespace, String id) {
        this.customActions.remove(new NamespacedKey(namespace, id));
    }

    @Override
    public void unregisterAllCustomActions() {
        this.customActions.clear();
    }

    @Override
    public boolean clearDialog(UUID uuid) {
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        player.clearDialog();
        return true;
    }
}

