/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.util.signgui.version;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.keehl.elevators.util.signgui.exception.SignGUIVersionException;
import me.keehl.elevators.util.signgui.version.VersionWrapper;
import org.bukkit.Bukkit;

public class VersionMatcher {
    private static final Map<String, String> VERSIONS;
    private static final String NEWEST_VERSION = "1_21_R5";
    private static boolean initialized;
    private static VersionWrapper wrapper;

    public static VersionWrapper getWrapper() throws SignGUIVersionException {
        if (!initialized) {
            initialized = true;
            wrapper = VersionMatcher.initWrapper();
            return wrapper;
        }
        if (wrapper == null) {
            throw new SignGUIVersionException("The previous attempt to initialize the version wrapper failed. This could be because this server version is not supported or because an error occured during initialization.");
        }
        return wrapper;
    }

    private static VersionWrapper initWrapper() throws SignGUIVersionException {
        String craftBukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
        String version = craftBukkitPackage.contains(".v") ? craftBukkitPackage.split("\\.")[3].substring(1) : VERSIONS.getOrDefault(Bukkit.getBukkitVersion().split("-")[0], NEWEST_VERSION);
        String className = VersionMatcher.useMojangMappings(version) ? VersionWrapper.class.getPackage().getName() + ".MojangWrapper" + version : VersionWrapper.class.getPackage().getName() + ".Wrapper" + version;
        try {
            return (VersionWrapper)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new SignGUIVersionException("Failed to load support for server version " + version, exception);
        }
        catch (ClassNotFoundException exception) {
            throw new SignGUIVersionException("SignGUI does not support the server version \"" + version + "\"", exception);
        }
    }

    private static boolean useMojangMappings(String version) {
        int minor;
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        String[] versionNumbers = version.replace("R", "").split("_");
        int major = Integer.parseInt(versionNumbers[1]);
        int n = minor = versionNumbers.length > 2 ? Integer.parseInt(versionNumbers[2]) : 0;
        if (major == 20 && minor == 4) {
            return true;
        }
        return major > 20;
    }

    static {
        HashMap<String, String> versions = new HashMap<String, String>();
        versions.put("1.20.5", "1_20_R4");
        versions.put("1.20.6", "1_20_R4");
        versions.put("1.21.1", "1_21_R1");
        versions.put("1.21.3", "1_21_R2");
        versions.put("1.21.4", "1_21_R3");
        versions.put("1.21.5", "1_21_R4");
        versions.put("1.21.6", NEWEST_VERSION);
        versions.put("1.21.7", NEWEST_VERSION);
        versions.put("1.21.8", NEWEST_VERSION);
        VERSIONS = Collections.unmodifiableMap(versions);
    }
}

