/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.IElevatorsPlugin;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorRecipeGroup;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.models.actions.IElevatorActionBuilder;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.models.settings.IElevatorSettingBuilder;
import me.keehl.elevators.api.services.IElevatorActionService;
import me.keehl.elevators.api.services.IElevatorConfigService;
import me.keehl.elevators.api.services.IElevatorDataContainerService;
import me.keehl.elevators.api.services.IElevatorEffectsService;
import me.keehl.elevators.api.services.IElevatorHologramService;
import me.keehl.elevators.api.services.IElevatorHookService;
import me.keehl.elevators.api.services.IElevatorListenerService;
import me.keehl.elevators.api.services.IElevatorObstructionService;
import me.keehl.elevators.api.services.IElevatorRecipeService;
import me.keehl.elevators.api.services.IElevatorSettingService;
import me.keehl.elevators.api.services.IElevatorTypeService;
import me.keehl.elevators.api.services.IElevatorUpdateService;
import me.keehl.elevators.api.services.IElevatorVersionService;
import me.keehl.elevators.api.services.configs.versions.IConfigEffect;
import me.keehl.elevators.api.services.configs.versions.IConfigElevatorType;
import me.keehl.elevators.api.services.configs.versions.IConfigHookData;
import me.keehl.elevators.api.services.configs.versions.IConfigLocale;
import me.keehl.elevators.api.services.configs.versions.IConfigRecipe;
import me.keehl.elevators.api.services.configs.versions.IConfigRoot;
import me.keehl.elevators.api.services.configs.versions.IConfigSettings;
import me.keehl.elevators.api.util.logging.ILogMessage;
import me.keehl.elevators.api.util.logging.ILogReleaseData;
import me.keehl.elevators.api.util.persistantDataTypes.ElevatorsDataType;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.MessageHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorRecipeGroup;
import me.keehl.elevators.models.ElevatorType;
import me.keehl.elevators.models.actions.ElevatorActionBuilder;
import me.keehl.elevators.models.settings.ElevatorSettingBuilder;
import me.keehl.elevators.services.ElevatorActionService;
import me.keehl.elevators.services.ElevatorConfigService;
import me.keehl.elevators.services.ElevatorDataContainerService;
import me.keehl.elevators.services.ElevatorEffectService;
import me.keehl.elevators.services.ElevatorHologramService;
import me.keehl.elevators.services.ElevatorHookService;
import me.keehl.elevators.services.ElevatorListenerService;
import me.keehl.elevators.services.ElevatorObstructionService;
import me.keehl.elevators.services.ElevatorRecipeService;
import me.keehl.elevators.services.ElevatorSettingService;
import me.keehl.elevators.services.ElevatorTypeService;
import me.keehl.elevators.services.ElevatorUpdateService;
import me.keehl.elevators.services.ElevatorVersionService;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigEffect;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigElevatorType;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigHookData;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigLocale;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigRecipe;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigRoot;
import me.keehl.elevators.services.configs.versions.configv5_2_0.ConfigSettings;
import me.keehl.elevators.util.config.ConfigConverter;
import me.keehl.elevators.util.folialib.FoliaLib;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

public class Elevators
implements IElevators {
    protected static JavaPlugin instance;
    protected static FoliaLib foliaLib;
    protected static boolean initialized;
    private static ElevatorActionService actionService;
    private static ElevatorConfigService configService;
    private static ElevatorDataContainerService dataContainerService;
    private static ElevatorEffectService effectsService;
    private static ElevatorHologramService hologramService;
    private static ElevatorHookService hookService;
    private static ElevatorListenerService listenerService;
    private static ElevatorObstructionService obstructionService;
    private static ElevatorRecipeService recipeService;
    private static ElevatorSettingService settingService;
    private static ElevatorTypeService typeService;
    private static ElevatorUpdateService updateService;
    private static ElevatorVersionService versionService;
    private static final LogStack mainLogStack;

    public Elevators(JavaPlugin plugin, FoliaLib foliaLib) {
        instance = plugin;
        Elevators.foliaLib = foliaLib;
        actionService = new ElevatorActionService(this);
        Bukkit.getServicesManager().register(IElevatorActionService.class, (Object)actionService, (Plugin)plugin, ServicePriority.Highest);
        configService = new ElevatorConfigService(this);
        Bukkit.getServicesManager().register(IElevatorConfigService.class, (Object)configService, (Plugin)plugin, ServicePriority.Highest);
        dataContainerService = new ElevatorDataContainerService(this);
        Bukkit.getServicesManager().register(IElevatorDataContainerService.class, (Object)dataContainerService, (Plugin)plugin, ServicePriority.Highest);
        effectsService = new ElevatorEffectService(this);
        Bukkit.getServicesManager().register(IElevatorEffectsService.class, (Object)effectsService, (Plugin)plugin, ServicePriority.Highest);
        hologramService = new ElevatorHologramService(this);
        Bukkit.getServicesManager().register(IElevatorHologramService.class, (Object)hologramService, (Plugin)plugin, ServicePriority.Highest);
        hookService = new ElevatorHookService(this);
        Bukkit.getServicesManager().register(IElevatorHookService.class, (Object)hookService, (Plugin)plugin, ServicePriority.Highest);
        listenerService = new ElevatorListenerService(this);
        Bukkit.getServicesManager().register(IElevatorListenerService.class, (Object)listenerService, (Plugin)plugin, ServicePriority.Highest);
        obstructionService = new ElevatorObstructionService(this);
        Bukkit.getServicesManager().register(IElevatorObstructionService.class, (Object)obstructionService, (Plugin)plugin, ServicePriority.Highest);
        recipeService = new ElevatorRecipeService(this);
        Bukkit.getServicesManager().register(IElevatorRecipeService.class, (Object)recipeService, (Plugin)plugin, ServicePriority.Highest);
        settingService = new ElevatorSettingService(this);
        Bukkit.getServicesManager().register(IElevatorSettingService.class, (Object)settingService, (Plugin)plugin, ServicePriority.Highest);
        typeService = new ElevatorTypeService(this);
        Bukkit.getServicesManager().register(IElevatorTypeService.class, (Object)typeService, (Plugin)plugin, ServicePriority.Highest);
        updateService = new ElevatorUpdateService(this);
        Bukkit.getServicesManager().register(IElevatorUpdateService.class, (Object)updateService, (Plugin)plugin, ServicePriority.Highest);
        versionService = new ElevatorVersionService(this);
        Bukkit.getServicesManager().register(IElevatorVersionService.class, (Object)versionService, (Plugin)plugin, ServicePriority.Highest);
        ConfigConverter.remapClass(IConfigEffect.class, ConfigEffect.class);
        ConfigConverter.remapClass(IElevatorType.class, ElevatorType.class);
        ConfigConverter.remapClass(IConfigElevatorType.IConfigActions.class, ConfigElevatorType.ConfigActions.class);
        ConfigConverter.remapClass(IConfigHookData.class, ConfigHookData.class);
        ConfigConverter.remapClass(IConfigLocale.class, ConfigLocale.class);
        ConfigConverter.remapClass(IConfigRecipe.class, ConfigRecipe.class);
        ConfigConverter.remapClass(IConfigRoot.class, ConfigRoot.class);
        ConfigConverter.remapClass(IConfigSettings.class, ConfigSettings.class);
        ConfigConverter.remapClass(IElevatorRecipeGroup.class, ElevatorRecipeGroup.class);
    }

    protected void enable() {
        this.pushAndHoldLog();
        actionService.onInitialize();
        configService.onInitialize();
        dataContainerService.onInitialize();
        effectsService.onInitialize();
        hologramService.onInitialize();
        hookService.onInitialize();
        listenerService.onInitialize();
        obstructionService.onInitialize();
        recipeService.onInitialize();
        settingService.onInitialize();
        typeService.onInitialize();
        updateService.onInitialize();
        versionService.onInitialize();
        this.popLog(logData -> this.log("Services enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        Elevators.reloadElevators();
        initialized = true;
    }

    public void disable() {
        this.log("Disabling services");
        this.pushLog();
        actionService.onUninitialize();
        configService.onUninitialize();
        dataContainerService.onUninitialize();
        effectsService.onUninitialize();
        hologramService.onUninitialize();
        hookService.onUninitialize();
        listenerService.onUninitialize();
        obstructionService.onUninitialize();
        recipeService.onUninitialize();
        settingService.onUninitialize();
        typeService.onUninitialize();
        updateService.onUninitialize();
        versionService.onUninitialize();
        this.saveConfig();
        initialized = false;
        this.popLog();
    }

    public void saveConfig() {
        File configFile = new File(instance.getDataFolder(), "config.yml");
        configService.saveConfig(configFile);
    }

    public static IConfigLocale getLocale() {
        return Elevators.getConfigService().getRootConfig().getLocale();
    }

    public static void reloadElevators() {
        boolean alreadyLoadedBefore = Elevators.getConfigService().isConfigLoaded();
        ElevatorsAPI.pushAndHoldLog();
        File configFile = new File(instance.getDataFolder(), "config.yml");
        instance.saveDefaultConfig();
        Elevators.getConfigService().loadConfig(configFile);
        Elevators.getInstance().saveConfig();
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Elevators " + (alreadyLoadedBefore ? "re" : "") + "loaded. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    @Override
    public JavaPlugin getPlugin() {
        return Elevators.getInstance();
    }

    public static JavaPlugin getInstance() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return (JavaPlugin)plugin;
        }
        return instance;
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public static File getConfigDirectory() {
        File configDirectory;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin == null) {
            plugin = Bukkit.getPluginManager().getPlugins()[0];
            configDirectory = new File(plugin.getDataFolder().getParent(), "Elevators");
        } else {
            configDirectory = plugin.getDataFolder();
        }
        try {
            configDirectory.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDirectory;
    }

    @Override
    public <T> IElevatorSettingBuilder<T> settingsBuilder(String settingKey, T defaultValue, PersistentDataType<?, T> persistentDataType) {
        return new ElevatorSettingBuilder<T>(settingKey, defaultValue, persistentDataType);
    }

    @Override
    public <T> IElevatorSettingBuilder<T> settingsBuilder(String settingKey, T defaultValue, ElevatorsDataType elevatorsDataType) {
        return new ElevatorSettingBuilder<T>(settingKey, defaultValue, elevatorsDataType);
    }

    @Override
    public IElevatorActionBuilder actionBuilder(String actionKey) {
        return new ElevatorActionBuilder(actionKey);
    }

    @Override
    public IElevator createElevatorRecord(ShulkerBox shulkerBox, IElevatorType elevatorType) {
        return new Elevator(shulkerBox, elevatorType);
    }

    @Override
    public IElevator createElevatorRecord(Block block) {
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(block);
        if (box == null) {
            return null;
        }
        IElevatorType elevatorType = ElevatorsAPI.getElevatorType(box);
        if (elevatorType == null) {
            return null;
        }
        return this.createElevatorRecord(box, elevatorType);
    }

    @Override
    public IElevatorType getElevatorType(ShulkerBox box) {
        return ElevatorHelper.getElevatorType(box);
    }

    @Override
    public void toggleElevatorProtectionHook(IElevator elevator, IProtectionHook protectionHook) {
        NamespacedKey containerKey = Elevators.getDataContainerService().getKeyFromKey("protection-" + protectionHook.getConfigKey(), IElevatorDataContainerService.booleanPersistentDataType);
        boolean currentValue = protectionHook.isCheckEnabled(elevator);
        Elevators.getDataContainerService().setElevatorValue(elevator.getShulkerBox(), containerKey, !currentValue);
        elevator.getShulkerBox().update();
    }

    @Override
    public IConfigHookData getElevatorProtectionHookConfig(IProtectionHook protectionHook) {
        if (!Elevators.getConfigService().getRootConfig().getProtectionHooks().containsKey(protectionHook.getConfigKey())) {
            Elevators.getConfigService().getRootConfig().getProtectionHooks().put(protectionHook.getConfigKey(), new ConfigHookData());
        }
        return Elevators.getConfigService().getRootConfig().getProtectionHooks().get(protectionHook.getConfigKey());
    }

    @Override
    public boolean isElevatorProtectionHookCheckEnabled(IElevator elevator, IProtectionHook protectionHook) {
        NamespacedKey containerKey = Elevators.getDataContainerService().getKeyFromKey("protection-" + protectionHook.getConfigKey(), IElevatorDataContainerService.booleanPersistentDataType);
        return Elevators.getDataContainerService().getElevatorValue(elevator.getShulkerBox(), containerKey, this.getElevatorProtectionHookConfig(protectionHook).doesBlockNonMemberUseByDefault());
    }

    public static ElevatorActionService getActionService() {
        return actionService;
    }

    public static ElevatorConfigService getConfigService() {
        return configService;
    }

    public static ElevatorDataContainerService getDataContainerService() {
        return dataContainerService;
    }

    public static ElevatorEffectService getEffectsService() {
        return effectsService;
    }

    public static ElevatorHologramService getHologramService() {
        return hologramService;
    }

    public static ElevatorHookService getHooksService() {
        return hookService;
    }

    public static ElevatorListenerService getListenerService() {
        return listenerService;
    }

    public static ElevatorRecipeService getRecipeService() {
        return recipeService;
    }

    public static ElevatorObstructionService getObstructionService() {
        return obstructionService;
    }

    public static ElevatorSettingService getSettingService() {
        return settingService;
    }

    public static ElevatorTypeService getElevatorTypeService() {
        return typeService;
    }

    public static ElevatorUpdateService getUpdateService() {
        return updateService;
    }

    public static ElevatorVersionService getVersionService() {
        return versionService;
    }

    public static Logger getElevatorsLogger() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Elevators");
        if (plugin != null) {
            return plugin.getLogger();
        }
        return Bukkit.getLogger();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    @Override
    public void log(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void log(Level level, Object message) {
        this.log(level, message, null);
    }

    @Override
    public void log(Level level, Object message, Throwable throwable) {
        if (throwable != null && level == Level.SEVERE) {
            ((IElevatorsPlugin)Elevators.getInstance()).log(level, message, throwable);
            return;
        }
        if ((message = mainLogStack.log(level, message.toString(), throwable)) == null) {
            return;
        }
        ((IElevatorsPlugin)Elevators.getInstance()).log(level, message, throwable);
    }

    @Override
    public Logger getLogger() {
        return ((IElevatorsPlugin)Elevators.getInstance()).getLogger();
    }

    @Override
    public ILocaleComponent createComponentFromText(String message) {
        return MessageHelper.getLocaleComponent(message);
    }

    @Override
    public void pushLog() {
        mainLogStack.push();
    }

    @Override
    public ILogReleaseData popLog(Consumer<ILogReleaseData> onPop) {
        LogReleaseData releaseData = mainLogStack.pop();
        if (onPop != null) {
            onPop.accept(releaseData);
        }
        for (ILogMessage message : releaseData.getLogs()) {
            this.log(message.getLevel(), message.getMessage(), message.getThrowable());
        }
        return releaseData;
    }

    @Override
    public ILogReleaseData popLog() {
        return this.popLog(null);
    }

    @Override
    public void holdLog() {
        mainLogStack.holdLogs();
    }

    @Override
    public void pushAndHoldLog() {
        this.pushLog();
        this.holdLog();
    }

    @Override
    public ILogReleaseData releaseLog(Consumer<ILogReleaseData> onRelease) {
        LogReleaseData released = mainLogStack.releaseLogs();
        if (onRelease != null) {
            onRelease.accept(released);
        }
        for (ILogMessage message : released.getLogs()) {
            this.log(message.getLevel(), message.getMessage(), message.getThrowable());
        }
        return released;
    }

    @Override
    public ILogReleaseData releaseLog() {
        return this.releaseLog(null);
    }

    static {
        initialized = false;
        mainLogStack = new LogStack();
    }

    public static class LogStack {
        private List<ILogMessage> heldMessages;
        private LogStack child;
        private long holdStart = -1L;

        public String log(Level level, String message, Throwable throwable) {
            if (this.child != null) {
                Object returnMessage = this.child.log(level, message, throwable);
                if (returnMessage == null) {
                    return null;
                }
                returnMessage = "\t" + (String)returnMessage;
                if (this.heldMessages != null) {
                    this.heldMessages.add(new LogMessage(level, message, throwable));
                    return null;
                }
                return returnMessage;
            }
            if (this.heldMessages != null) {
                this.heldMessages.add(new LogMessage(level, message, throwable));
                return null;
            }
            return message;
        }

        public void push() {
            if (this.child != null) {
                this.child.push();
                return;
            }
            this.child = new LogStack();
        }

        public LogReleaseData pop() {
            if (this.child != null) {
                boolean noGrandChild = this.child.child == null;
                LogReleaseData logs = this.child.pop();
                if (noGrandChild) {
                    this.child = null;
                }
                return logs;
            }
            return this.releaseLogs();
        }

        public void holdLogs() {
            if (this.child != null) {
                this.child.holdLogs();
                return;
            }
            this.holdStart = System.currentTimeMillis();
            this.heldMessages = new ArrayList<ILogMessage>();
        }

        public LogReleaseData releaseLogs() {
            if (this.child != null) {
                LogReleaseData childLogs = this.child.releaseLogs();
                if (this.heldMessages != null) {
                    this.heldMessages.addAll(childLogs.messages);
                    return null;
                }
                return childLogs;
            }
            long elapsed = System.currentTimeMillis() - (this.holdStart == -1L ? System.currentTimeMillis() : this.holdStart);
            if (this.heldMessages == null) {
                return new LogReleaseData(elapsed, new ArrayList<ILogMessage>());
            }
            for (ILogMessage heldMessage : this.heldMessages) {
                heldMessage.setMessage("\t" + heldMessage.getMessage());
            }
            LogReleaseData data = new LogReleaseData(elapsed, this.heldMessages);
            this.heldMessages = null;
            return data;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="elapsed", type=long.class), @RecordComponents.Value(name="messages", type=List.class)})
    public static final class LogReleaseData
    extends J_L_Record
    implements ILogReleaseData {
        private final long elapsed;
        private final List<ILogMessage> messages;

        public LogReleaseData(long elapsed, List<ILogMessage> messages) {
            this.elapsed = elapsed;
            this.messages = messages;
        }

        @Override
        public long getElapsedTime() {
            return this.elapsed;
        }

        @Override
        public List<ILogMessage> getLogs() {
            return this.messages;
        }

        @Override
        public final String toString() {
            return LogReleaseData.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return LogReleaseData.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return LogReleaseData.jvmdowngrader$equals$equals(this, o);
        }

        public long elapsed() {
            return this.elapsed;
        }

        public List<ILogMessage> messages() {
            return this.messages;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(LogReleaseData logReleaseData) {
            LogReleaseData logReleaseData2 = logReleaseData;
            return "Elevators$LogReleaseData[" + "elapsed=" + logReleaseData.elapsed + ", " + "messages=" + logReleaseData.messages + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(LogReleaseData logReleaseData) {
            Object[] objectArray = new Object[]{logReleaseData.elapsed, logReleaseData.messages};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(LogReleaseData logReleaseData, Object object) {
            if (logReleaseData == object) {
                return true;
            }
            if (object != null && object instanceof LogReleaseData) {
                LogReleaseData logReleaseData2 = (LogReleaseData)object;
                if (logReleaseData.elapsed == logReleaseData2.elapsed && Objects.equals(logReleaseData.messages, logReleaseData2.messages)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class LogMessage
    implements ILogMessage {
        private String message;
        private final Throwable throwable;
        private final Level level;

        public LogMessage(Level level, String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
            this.level = level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public void setMessage(String message) {
            this.message = message;
        }
    }
}

