/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators;

import elevators.xyz.wagyourtail.jvmdg.j18.stub.java_base.J_L_System;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import me.keehl.elevators.CustomLogger;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.IElevatorsPlugin;
import me.keehl.elevators.helpers.ElevatorMenuHelper;
import me.keehl.elevators.helpers.ResourceHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.ElevatorsStartupService;
import me.keehl.elevators.util.faststats.bukkit.BukkitMetrics;
import me.keehl.elevators.util.faststats.core.Metrics;
import me.keehl.elevators.util.folialib.FoliaLib;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ElevatorsPlugin
extends JavaPlugin
implements IElevatorsPlugin {
    private static final String LIGHT_GRAY = "\u001b[38;5;250m";
    private static final String YELLOW = "\u001b[33m";
    private static final String RED = "\u001b[31m";
    private static final String RESET = "\u001b[0m";
    private static final String BOLD = "\u001b[1m";
    private me.keehl.elevators.util.bstats.bukkit.Metrics bstatsMetrics;
    private Metrics fastStatsMetrics;
    private final FoliaLib foliaLib = new FoliaLib(this);
    private CustomLogger customLogger;
    private Elevators elevators;

    private void printBanner() {
        String version = "Version: " + this.getDescription().getVersion();
        String server = this.foliaLib.getImplType().name() + " " + Bukkit.getServer().getVersion();
        String java = "Java Version:" + J_L_System.getProperty("java.version");
        String operatingSystem = "OS: " + J_L_System.getProperty("os.name") + " " + J_L_System.getProperty("os.version");
        Bukkit.getLogger().info("\n\u001b[31m  _____ _               _                  \n\u001b[31m | ____| | _____   ___ | |_ ___  _ __ ___  \u001b[1m\u001b[38;5;250m    " + version + "\n\u001b[31m |  _| | |/ _ \\ \\ / / \\| __/ _ \\| '__/ __| \u001b[1m\u001b[38;5;250m    " + server + "\n\u001b[31m | |___| |  __/\\ V / \u039b \\ || (_) | |  \\__ \\ \u001b[1m\u001b[38;5;250m    " + java + "\n\u001b[31m |_____|_|\\___| \\_/_/ \\_\\__\\___/|_|  |___/ \u001b[1m\u001b[38;5;250m    " + operatingSystem + "\n\u001b[31m                                            \u001b[0m");
    }

    public void onLoad() {
        this.elevators = new Elevators(this, this.foliaLib);
        Bukkit.getServicesManager().register(IElevators.class, (Object)this.elevators, (Plugin)this, ServicePriority.Highest);
        ElevatorsStartupService.buildElevatorsEarly(this, this.foliaLib);
    }

    public void onEnable() {
        this.getLogger().setFilter(new ElevatorLoggingFilter(this.getLogger().getFilter()));
        this.customLogger = new CustomLogger(this.getLogger());
        this.printBanner();
        ElevatorsAPI.pushAndHoldLog();
        ElevatorsAPI.pushAndHoldLog();
        try {
            this.fastStatsMetrics = BukkitMetrics.factory().token("ac50ca9cdff9c38b8a7aeea15b63ded6").create((Plugin)this);
        }
        catch (Exception ex) {
            ElevatorsAPI.log(Level.WARNING, "Failed to load FastStats:\n" + ResourceHelper.cleanTrace(ex));
        }
        try {
            this.bstatsMetrics = new me.keehl.elevators.util.bstats.bukkit.Metrics((Plugin)this, 8026);
        }
        catch (Exception ex) {
            ElevatorsAPI.log(Level.WARNING, "Failed to load BStats:\n" + ResourceHelper.cleanTrace(ex));
        }
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Metrics enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
        if (VersionHelper.doesVersionSupportDialogs()) {
            ElevatorMenuHelper.registerDialogManager();
        }
        this.elevators.enable();
        ElevatorsStartupService.buildElevators(this, this.foliaLib);
        ElevatorsAPI.popLog(logData -> ElevatorsAPI.log("Plugin enabled. " + String.valueOf(ChatColor.YELLOW) + "Took " + logData.getElapsedTime() + "ms"));
    }

    public void onDisable() {
        if (this.bstatsMetrics != null) {
            this.getLogger().info("Disabling BStats Metrics");
            this.bstatsMetrics.shutdown();
        }
        if (this.fastStatsMetrics != null) {
            this.getLogger().info("Disabling FastStats Metrics");
            this.fastStatsMetrics.shutdown();
        }
        ElevatorMenuHelper.unregisterDialogManager();
        this.elevators.disable();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        if (this.customLogger == null) {
            return super.getLogger();
        }
        return this.customLogger;
    }

    @Override
    public void log(Object message) {
        if (message == null) {
            message = "";
        }
        super.getLogger().log(Level.INFO, message.toString());
    }

    @Override
    public void log(Level level, Object message) {
        if (message == null) {
            message = "";
        }
        super.getLogger().log(level, message.toString());
    }

    @Override
    public void log(Level level, Object message, Throwable throwable) {
        if (message == null) {
            message = "";
        }
        super.getLogger().log(level, message.toString());
        if (throwable == null) {
            return;
        }
        super.getLogger().log(level, ResourceHelper.cleanTrace(throwable));
    }

    public static class ElevatorLoggingFilter
    implements Filter {
        private final Filter delegate;

        public ElevatorLoggingFilter(Filter delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            record.setLoggerName("\u001b[1m\u001b[31mElevators\u001b[0m");
            Object message = record.getLevel() == Level.WARNING ? ElevatorsPlugin.YELLOW + record.getMessage() : (record.getLevel() == Level.SEVERE ? ElevatorsPlugin.RED + record.getMessage() : ElevatorsPlugin.LIGHT_GRAY + record.getMessage());
            message = ((String)message).replace("\u00a7e", ElevatorsPlugin.YELLOW);
            record.setMessage((String)message + ElevatorsPlugin.RESET);
            return this.delegate == null || this.delegate.isLoggable(record);
        }
    }
}

