/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.actions.settings;

import java.util.function.Consumer;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorActionSetting;
import me.keehl.elevators.api.models.IElevatorActionVariable;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.util.PentaConsumer;
import me.keehl.elevators.models.settings.ElevatorSetting;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;

public class ElevatorActionSetting<T>
extends ElevatorSetting<String>
implements IElevatorActionSetting<T> {
    private final IElevatorAction elevatorAction;
    private final IElevatorActionVariable<T> actionGrouping;
    private final boolean useDataStore;
    private PentaConsumer<Player, Runnable, InventoryClickEvent, T, Consumer<T>> onClickMethod;

    public ElevatorActionSetting(JavaPlugin plugin, IElevatorAction action, IElevatorActionVariable<T> grouping, @Subst(value="test_key") String settingName, String settingDisplayName, String description, Material icon, boolean useDataStore) {
        super(plugin, action.getKey() + "/" + settingName, settingDisplayName, description, icon);
        this.elevatorAction = action;
        this.actionGrouping = grouping;
        this.useDataStore = useDataStore;
        if (useDataStore) {
            this.setupDataStore(settingName, (PersistentDataType<?, String>)PersistentDataType.STRING);
        }
    }

    @Override
    public void onClick(PentaConsumer<Player, Runnable, InventoryClickEvent, T, Consumer<T>> setValueGlobalMethod) {
        this.onClickMethod = setValueGlobalMethod;
    }

    @Override
    public void onClickGlobal(Player player, IElevatorType elevatorType, Runnable returnMethod, InventoryClickEvent clickEvent, String currentValue) {
        this.onClickMethod.accept(player, returnMethod, clickEvent, this.actionGrouping.getObjectFromString(currentValue, this.elevatorAction), val -> this.elevatorAction.setGroupingObject(this.actionGrouping, val));
    }

    @Override
    public void onClickIndividual(Player player, IElevator elevator, Runnable returnMethod, InventoryClickEvent clickEvent, String currentValue) {
        this.elevatorAction.initIdentifier();
        this.onClickMethod.accept(player, returnMethod, clickEvent, this.actionGrouping.getObjectFromString(currentValue, this.elevatorAction), val -> this.setIndividualValue(elevator, this.actionGrouping.getStringFromObject(val)));
    }

    @Override
    public String getGlobalValue(IElevatorType elevatorType) {
        return this.actionGrouping.getStringFromObject(this.elevatorAction.getVariableValue(this.actionGrouping));
    }

    @Override
    public IElevatorSetting<String> setupDataStore(String settingKey, PersistentDataType<?, String> dataType) {
        if (this.elevatorAction.getIdentifier() != null) {
            settingKey = String.valueOf(this.elevatorAction.getIdentifier()) + "-" + (String)settingKey;
        }
        return super.setupDataStore((String)settingKey, dataType);
    }

    @Override
    public boolean canBeEditedIndividually(IElevator elevator) {
        return this.useDataStore;
    }
}

