/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.keehl.elevators.api.IElevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.actions.IElevatorActionBuilder;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.models.settings.IElevatorSettingBuilder;
import me.keehl.elevators.api.services.configs.versions.IConfigHookData;
import me.keehl.elevators.api.util.logging.ILogReleaseData;
import me.keehl.elevators.api.util.persistantDataTypes.ElevatorsDataType;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.persistence.PersistentDataType;
import org.intellij.lang.annotations.Pattern;
import org.intellij.lang.annotations.Subst;

public class ElevatorsAPI {
    public static IElevators getElevators() {
        return Optional.ofNullable((IElevators)Bukkit.getServicesManager().load(IElevators.class)).orElseThrow();
    }

    public static <T> IElevatorSettingBuilder<T> settingsBuilder(@Pattern(value="[a-z0-9/._-]+") @Subst(value="test_key") String settingKey, T defaultValue, PersistentDataType<?, T> persistentDataType) {
        return ElevatorsAPI.getElevators().settingsBuilder(settingKey, defaultValue, persistentDataType);
    }

    public static <T> IElevatorSettingBuilder<T> settingsBuilder(@Pattern(value="[a-z0-9/._-]+") @Subst(value="test_key") String settingKey, T defaultValue, ElevatorsDataType elevatorsDataType) {
        return ElevatorsAPI.getElevators().settingsBuilder(settingKey, defaultValue, elevatorsDataType);
    }

    public static IElevatorActionBuilder actionBuilder(@Pattern(value="[a-z0-9/._-]+") @Subst(value="test_key") String actionKey) {
        return ElevatorsAPI.getElevators().actionBuilder(actionKey);
    }

    public static IElevator createElevatorRecord(ShulkerBox box, IElevatorType elevatorType) {
        return ElevatorsAPI.getElevators().createElevatorRecord(box, elevatorType);
    }

    public static IElevator createElevatorRecord(Block block) {
        return ElevatorsAPI.getElevators().createElevatorRecord(block);
    }

    public static IElevatorType getElevatorType(ShulkerBox box) {
        return ElevatorsAPI.getElevators().getElevatorType(box);
    }

    public static void toggleElevatorProtectionHook(IElevator elevator, IProtectionHook protectionHook) {
        ElevatorsAPI.getElevators().toggleElevatorProtectionHook(elevator, protectionHook);
    }

    public static IConfigHookData getElevatorProtectionHookConfig(IProtectionHook protectionHook) {
        return ElevatorsAPI.getElevators().getElevatorProtectionHookConfig(protectionHook);
    }

    public static boolean isElevatorProtectionHookCheckEnabled(IElevator elevator, IProtectionHook protectionHook) {
        return ElevatorsAPI.getElevators().isElevatorProtectionHookCheckEnabled(elevator, protectionHook);
    }

    public static void log(Object message) {
        ElevatorsAPI.getElevators().log(message);
    }

    public static void log(Level level, Object message) {
        ElevatorsAPI.getElevators().log(level, message);
    }

    public static void log(Level level, Object message, Throwable throwable) {
        ElevatorsAPI.getElevators().log(level, message, throwable);
    }

    public static void pushLog() {
        ElevatorsAPI.getElevators().pushLog();
    }

    public static ILogReleaseData popLog(Consumer<ILogReleaseData> onPop) {
        return ElevatorsAPI.getElevators().popLog(onPop);
    }

    public static ILogReleaseData popLog() {
        return ElevatorsAPI.getElevators().popLog();
    }

    public static void holdLog() {
        ElevatorsAPI.getElevators().holdLog();
    }

    public static void pushAndHoldLog() {
        ElevatorsAPI.getElevators().pushAndHoldLog();
    }

    public static ILogReleaseData releaseLog(Consumer<ILogReleaseData> onRelease) {
        return ElevatorsAPI.getElevators().releaseLog(onRelease);
    }

    public static ILogReleaseData releaseLog() {
        return ElevatorsAPI.getElevators().releaseLog();
    }

    public static Logger getLogger() {
        return ElevatorsAPI.getElevators().getLogger();
    }
}

