/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.models.actions.IElevatorActionBuilder;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.models.settings.IElevatorSettingBuilder;
import me.keehl.elevators.api.services.configs.versions.IConfigHookData;
import me.keehl.elevators.api.util.logging.ILogReleaseData;
import me.keehl.elevators.api.util.persistantDataTypes.ElevatorsDataType;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Pattern;

public interface IElevators {
    public JavaPlugin getPlugin();

    public void log(Object var1);

    public void log(Level var1, Object var2);

    public void log(Level var1, Object var2, Throwable var3);

    public void pushLog();

    public ILogReleaseData popLog(Consumer<ILogReleaseData> var1);

    public ILogReleaseData popLog();

    public void holdLog();

    public void pushAndHoldLog();

    public ILogReleaseData releaseLog(Consumer<ILogReleaseData> var1);

    public ILogReleaseData releaseLog();

    public Logger getLogger();

    public ILocaleComponent createComponentFromText(String var1);

    public <T> IElevatorSettingBuilder<T> settingsBuilder(@Pattern(value="[a-z0-9/._-]+") String var1, T var2, PersistentDataType<?, T> var3);

    public <T> IElevatorSettingBuilder<T> settingsBuilder(@Pattern(value="[a-z0-9/._-]+") String var1, T var2, ElevatorsDataType var3);

    public IElevatorActionBuilder actionBuilder(String var1);

    public IElevator createElevatorRecord(ShulkerBox var1, IElevatorType var2);

    public IElevator createElevatorRecord(Block var1);

    public IElevatorType getElevatorType(ShulkerBox var1);

    public void toggleElevatorProtectionHook(IElevator var1, IProtectionHook var2);

    public IConfigHookData getElevatorProtectionHookConfig(IProtectionHook var1);

    public boolean isElevatorProtectionHookCheckEnabled(IElevator var1, IProtectionHook var2);
}

