/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api.models;

import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorEffect;
import me.keehl.elevators.api.models.IElevatorEventData;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public abstract class ElevatorEffect
implements IElevatorEffect {
    private final String effectKey;
    private final ItemStack icon;

    public ElevatorEffect(String effectKey, ItemStack icon) {
        this.effectKey = effectKey.toUpperCase();
        this.icon = icon;
    }

    protected Location getEffectLocation(IElevator elevator) {
        return elevator.getLocation().clone();
    }

    private Color extractColorFromDyeColor(DyeColor dyeColor) {
        return dyeColor == null ? Color.WHITE : dyeColor.getColor();
    }

    protected Color getParticleColor(IElevator elevator) {
        return this.extractColorFromDyeColor(elevator.getDyeColor());
    }

    @Override
    public String getEffectKey() {
        return this.effectKey;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public abstract void playEffect(IElevatorEventData var1, IElevator var2);
}

