/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api.models.hooks;

import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.IProtectionHook;
import me.keehl.elevators.api.services.configs.versions.IConfigHookData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ProtectionHook
implements IProtectionHook {
    private final String configKey;

    public ProtectionHook(String configKey) {
        this.configKey = configKey;
    }

    @Override
    public IConfigHookData getConfig() {
        return ElevatorsAPI.getElevatorProtectionHookConfig(this);
    }

    @Override
    public boolean isCheckEnabled(IElevator elevator) {
        return ElevatorsAPI.isElevatorProtectionHookCheckEnabled(elevator, this);
    }

    @Override
    public void toggleCheckEnabled(IElevator elevator) {
        ElevatorsAPI.toggleElevatorProtectionHook(elevator, this);
    }

    @Override
    public String getConfigKey() {
        return this.configKey;
    }

    @Override
    public abstract void onProtectionClick(Player var1, IElevator var2, Runnable var3);

    @Override
    public abstract boolean canEditName(Player var1, IElevator var2, boolean var3);

    @Override
    public abstract boolean canEditSettings(Player var1, IElevator var2, boolean var3);

    @Override
    public abstract boolean canPlayerUseElevator(Player var1, IElevator var2, boolean var3);

    @Override
    public abstract ItemStack createIconForElevator(Player var1, IElevator var2);
}

