/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api.services;

import java.nio.charset.Charset;
import java.util.Optional;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.IElevatorService;
import me.keehl.elevators.api.util.persistantDataTypes.BooleanPersistentDataType;
import me.keehl.elevators.api.util.persistantDataTypes.LocaleComponentArrayDataType;
import me.keehl.elevators.api.util.persistantDataTypes.LocaleComponentDataType;
import me.keehl.elevators.api.util.persistantDataTypes.StringArrayDataType;
import org.bukkit.NamespacedKey;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public interface IElevatorDataContainerService
extends IElevatorService {
    public static final StringArrayDataType stringArrayPersistentDataType = new StringArrayDataType(Charset.defaultCharset());
    public static final BooleanPersistentDataType booleanPersistentDataType = new BooleanPersistentDataType();
    public static final LocaleComponentDataType localeComponentPersistentDataType = new LocaleComponentDataType();
    public static final LocaleComponentArrayDataType localeComponentArrayPersistentDataType = new LocaleComponentArrayDataType();

    public NamespacedKey createKey(String var1);

    public NamespacedKey getKeyFromKey(String var1, PersistentDataType<?, ?> var2);

    public void dumpDataFromShulkerBoxIntoItem(ShulkerBox var1, ItemStack var2);

    public void dumpDataFromItemIntoShulkerBox(ShulkerBox var1, ItemStack var2);

    public void dumpDataFromItemIntoItem(ItemStack var1, ItemStack var2);

    public String getElevatorKey(ItemStack var1);

    public String getElevatorKey(ShulkerBox var1);

    public <T> T getElevatorValue(ShulkerBox var1, NamespacedKey var2, T var3);

    public <Z> void setElevatorValue(ShulkerBox var1, NamespacedKey var2, Z var3);

    public void setElevatorKey(ItemStack var1, IElevatorType var2);

    public ShulkerBox updateTypeKeyOnElevator(ShulkerBox var1, IElevatorType var2);

    public ShulkerBox updateBox(ShulkerBox var1, IElevatorType var2);

    public void updateItemStackFromV2(ItemStack var1, IElevatorType var2);

    public Optional<String> getFloorNameOpt(IElevator var1);

    public String getFloorName(IElevator var1);

    public void setFloorName(IElevator var1, String var2);
}

