/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.api.util.persistantDataTypes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.ILocaleComponent;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class LocaleComponentArrayDataType
implements PersistentDataType<byte[], ILocaleComponent[]> {
    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<ILocaleComponent[]> getComplexType() {
        return ILocaleComponent[].class;
    }

    public byte @NotNull [] toPrimitive(ILocaleComponent[] components, @NotNull PersistentDataAdapterContext context) {
        byte[][] allStringBytes = new byte[components.length][];
        int total = 0;
        for (int i = 0; i < allStringBytes.length; ++i) {
            byte[] bytes = components[i].serialize().getBytes();
            allStringBytes[i] = bytes;
            total += bytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(total + allStringBytes.length * 4);
        for (byte[] bytes : allStringBytes) {
            buffer.putInt(bytes.length);
            buffer.put(bytes);
        }
        return buffer.array();
    }

    @NotNull
    public @NotNull ILocaleComponent @NotNull [] fromPrimitive(byte @NotNull [] bytes, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        ArrayList<ILocaleComponent> list = new ArrayList<ILocaleComponent>();
        while (buffer.remaining() > 0 && buffer.remaining() >= 4) {
            int stringLength = buffer.getInt();
            if (buffer.remaining() < stringLength) break;
            byte[] stringBytes = new byte[stringLength];
            buffer.get(stringBytes);
            list.add(ElevatorsAPI.getElevators().createComponentFromText(new String(stringBytes)));
        }
        return list.toArray(new ILocaleComponent[0]);
    }
}

