/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.effects;

import java.util.ArrayList;
import java.util.Objects;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.ElevatorEffect;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.helpers.ItemStackHelper;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;

public class ArrowEffect
extends ElevatorEffect {
    public ArrowEffect() {
        super("ARROW", ItemStackHelper.createItem("Arrow", Material.TIPPED_ARROW, 1));
    }

    @Override
    public void playEffect(IElevatorEventData teleportResult, IElevator elevator) {
        int i;
        byte direction = teleportResult.getDirection();
        Color particleColor = this.getParticleColor(elevator);
        Location locClone = this.getEffectLocation(elevator).getBlock().getLocation();
        locClone.add(0.5, direction == 1 ? 1.0 : 3.0, 0.5);
        ArrayList<Location> spawnPositions = new ArrayList<Location>();
        for (i = 0; i < 20; ++i) {
            spawnPositions.add(locClone.add(0.0, (double)direction * 0.1, 0.0).clone());
        }
        for (i = 5; i >= 0; --i) {
            for (int z = 0; z < 2; ++z) {
                double y;
                Location clone = locClone.clone();
                double d = y = direction == 1 ? (double)(-i) * 0.1 : (double)i * 0.1;
                if (z == 0) {
                    clone.add((double)(-i) * 0.1, y, 0.0);
                    spawnPositions.add(clone.clone());
                    clone.add((double)i * 0.2, 0.0, 0.0);
                } else {
                    clone.add(0.0, y, (double)(-i) * 0.1);
                    spawnPositions.add(clone.clone());
                    clone.add(0.0, 0.0, (double)i * 0.2);
                }
                spawnPositions.add(clone.clone());
            }
        }
        for (i = 0; i < 10; ++i) {
            Elevators.getFoliaLib().getScheduler().runAtLocationLater(elevator.getLocation(), task -> {
                for (Location location1 : spawnPositions) {
                    Objects.requireNonNull(location1.getWorld()).spawnParticle(Particle.REDSTONE, location1, 1, 0.0, 0.0, 0.0, 1.0, (Object)new Particle.DustOptions(particleColor, 1.0f));
                }
            }, (long)(i * 2));
        }
    }
}

