/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.awt.image.IndexColorModel;
import me.keehl.elevators.helpers.VersionHelper;
import org.bukkit.ChatColor;

public class ColorHelper {
    private static final IndexColorModel colorModel;
    private static final char[] DIGITS_LOWER;
    private static final char[] DIGITS_UPPER;

    public static int getRGBFromHex(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int i = Integer.valueOf(hex, 16);
        return 0xFF000000 | (i >> 16 & 0xFF) << 16 | (i >> 8 & 0xFF) << 8 | i & 0xFF;
    }

    public static ChatColor nearestColor(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int rgb = ColorHelper.getRGBFromHex(hex);
        return ChatColor.values()[((byte[])colorModel.getDataElements(rgb, null))[0]];
    }

    public static String getChatStringFromColor(int rgb) {
        char[] var2;
        if (!VersionHelper.doesVersionSupportHex()) {
            return ChatColor.values()[((byte[])colorModel.getDataElements(rgb, null))[0]].toString();
        }
        String hex = String.format("%02x%02x%02x", rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        StringBuilder code = new StringBuilder("\u00a7x");
        for (char c : var2 = hex.toCharArray()) {
            code.append('\u00a7').append(c);
        }
        return code.toString();
    }

    public static String getColor(String hex) {
        char[] var2;
        if (!VersionHelper.doesVersionSupportHex()) {
            return ColorHelper.nearestColor(hex).toString();
        }
        StringBuilder code = new StringBuilder("\u00a7x");
        for (char c : var2 = hex.toCharArray()) {
            code.append('\u00a7').append(c);
        }
        return code.toString();
    }

    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = ColorHelper.toDigit(data[j], j) << 4;
            f |= ColorHelper.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        return ColorHelper.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return ColorHelper.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return new String(ColorHelper.encodeHex(data));
    }

    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    static {
        DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int[] colorMap = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -43691, -43521, -171, -1};
        colorModel = new IndexColorModel(4, 16, colorMap, 0, false, -1, 0);
    }
}

