/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.List;
import java.util.UUID;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import me.keehl.elevators.events.ElevatorMenuOpenEvent;
import me.keehl.elevators.events.ElevatorUseEvent;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.menus.interact.InteractMenu;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorEventData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ElevatorHelper {
    public static boolean isElevator(InventoryHolder inventoryHolder) {
        if (!(inventoryHolder instanceof BlockState)) {
            return false;
        }
        return ElevatorHelper.isElevator((BlockState)inventoryHolder);
    }

    public static boolean isElevator(BlockState blockState) {
        if (!ShulkerBoxHelper.isShulkerBox(blockState)) {
            return false;
        }
        return Elevators.getVersionService().getElevatorType((ShulkerBox)blockState, false) != null;
    }

    public static boolean isElevator(ShulkerBox box) {
        return Elevators.getVersionService().getElevatorType(box, false) != null;
    }

    public static boolean isElevator(Block block) {
        return Elevators.getVersionService().getElevatorType(block) != null;
    }

    public static boolean isElevator(ItemStack itemStack) {
        return Elevators.getVersionService().getElevatorType(itemStack) != null;
    }

    public static boolean isElevator(Item item) {
        return Elevators.getVersionService().getElevatorType(item.getItemStack()) != null;
    }

    public static IElevatorType getElevatorType(ItemStack item) {
        return Elevators.getVersionService().getElevatorType(item);
    }

    public static IElevatorType getElevatorType(Block block) {
        return Elevators.getVersionService().getElevatorType(block);
    }

    public static IElevatorType getElevatorType(ShulkerBox box) {
        return Elevators.getVersionService().getElevatorType(box, true);
    }

    public static IElevatorType getElevatorType(ShulkerBox box, boolean updateBlock) {
        return Elevators.getVersionService().getElevatorType(box, updateBlock);
    }

    public static int getFloorNumberOrCount(IElevator elevator, boolean stopAtProvidedBox) {
        IElevatorEventData searchResult;
        Location startingLocation = elevator.getLocation();
        while ((searchResult = ElevatorHelper.findDestinationElevator(null, startingLocation, elevator, (byte)-1, false, false, true)) != null) {
            startingLocation = searchResult.getDestination().getLocation();
        }
        if (elevator.getLocation().getBlockY() == startingLocation.getBlockY() && stopAtProvidedBox) {
            return 1;
        }
        int floor = 1;
        while ((searchResult = ElevatorHelper.findDestinationElevator(null, startingLocation, elevator, (byte)1, false, false, true)) != null) {
            ++floor;
            startingLocation = searchResult.getDestination().getLocation();
            if (!stopAtProvidedBox || startingLocation.getY() != (double)elevator.getLocation().getBlockY()) continue;
            break;
        }
        return floor;
    }

    public static IElevatorEventData findDestinationElevator(Player player, IElevator elevator, byte direction) {
        return ElevatorHelper.findDestinationElevator(player, elevator.getLocation(), elevator, direction, false, false, false);
    }

    public static IElevatorEventData findDestinationElevator(Player player, Location origin, IElevator elevator, byte direction, boolean ignoreSolidBlockCheck, boolean ignoreDistanceCheck, boolean ignoreObstructionCheck) {
        if ((direction = (byte)(direction > 0 ? 1 : -1)) == -1 && origin.getBlockY() == VersionHelper.getWorldMinHeight(origin.getWorld())) {
            return null;
        }
        World world = origin.getWorld();
        int worldMinHeight = VersionHelper.getWorldMinHeight(world);
        int maxDistance = (Integer)Elevators.getSettingService().getElevatorSettingValue(elevator, InternalElevatorSettingType.MAX_DISTANCE);
        if (maxDistance == -1 || ignoreDistanceCheck) {
            maxDistance = Short.MAX_VALUE;
        }
        int endPointY = Math.min(Math.max(origin.getBlockY() + maxDistance * direction, worldMinHeight), world.getMaxHeight());
        boolean stopsObstruction = (Boolean)Elevators.getSettingService().getElevatorSettingValue(elevator, InternalElevatorSettingType.STOP_OBSTRUCTION);
        boolean checkColor = (Boolean)Elevators.getSettingService().getElevatorSettingValue(elevator, InternalElevatorSettingType.CHECK_COLOR);
        boolean checksClass = (Boolean)Elevators.getSettingService().getElevatorSettingValue(elevator, InternalElevatorSettingType.CLASS_CHECK);
        int maxSolidBlocks = (Integer)Elevators.getSettingService().getElevatorSettingValue(elevator, InternalElevatorSettingType.MAX_SOLID_BLOCKS);
        int solidBlocks = maxSolidBlocks == -1 || ignoreSolidBlockCheck ? Short.MIN_VALUE : 0;
        Location tempLocation = origin.clone();
        do {
            double addition;
            ShulkerBox tempShulkerBox;
            Block tempBlock;
            if ((tempBlock = (tempLocation = tempLocation.add(0.0, (double)direction, 0.0)).getBlock()).getType().isSolid()) {
                ++solidBlocks;
            }
            if ((tempShulkerBox = ShulkerBoxHelper.getShulkerBox(tempBlock)) == null) continue;
            IElevatorType tempElevatorType = ElevatorHelper.getElevatorType(tempShulkerBox, false);
            Elevator tempElevator = new Elevator(tempShulkerBox, tempElevatorType);
            if (tempElevatorType == null || checksClass && !elevator.getElevatorType().equals(tempElevatorType)) continue;
            if (--solidBlocks >= maxSolidBlocks) {
                return null;
            }
            if (tempShulkerBox.getColor() != elevator.getDyeColor() && checkColor) continue;
            if (!stopsObstruction || ignoreObstructionCheck) {
                return new ElevatorEventData(player, elevator, tempElevator, direction, 0.0);
            }
            double d = addition = player != null ? Elevators.getObstructionService().getHitBoxAddition(tempBlock.getRelative(BlockFace.UP), player) : 0.0;
            if (!(addition >= 0.0)) continue;
            return new ElevatorEventData(player, elevator, tempElevator, direction, Math.abs(addition));
        } while (tempLocation.getBlockY() != endPointY);
        return null;
    }

    public static void setElevatorDisabled(ShulkerBox shulkerBox) {
        shulkerBox.setMetadata("elevator-disabled", (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)true));
    }

    public static void setElevatorEnabled(ShulkerBox shulkerBox) {
        shulkerBox.removeMetadata("elevator-disabled", (Plugin)Elevators.getInstance());
    }

    public static void resetElevatorEditState(IElevator elevator) {
        ElevatorHelper.setElevatorEnabled(elevator.getShulkerBox());
        ShulkerBoxHelper.playClose(elevator.getShulkerBox());
        elevator.getShulkerBox().removeMetadata("open-player", (Plugin)Elevators.getInstance());
    }

    public static void onElevatorInteract(Player player, PlayerInteractEvent event, IElevator elevator) {
        if (ElevatorHelper.isElevatorDisabled(elevator.getShulkerBox())) {
            return;
        }
        Elevators.getHologramService().updateElevatorHologram(elevator);
        if (!elevator.getElevatorType(true).shouldAllowIndividualEdit()) {
            return;
        }
        if (!Elevators.getHooksService().canEditElevator(player, elevator, true)) {
            boolean reset;
            List values = elevator.getShulkerBox().getMetadata("open-player");
            List<Player> players = J_U_S_Stream.toList(values.stream().map(MetadataValue::asString).map(UUID::fromString).map(Bukkit::getPlayer));
            boolean bl = reset = players.isEmpty() || J_U_List.getFirst(players).getUniqueId().equals(player.getUniqueId());
            if (reset) {
                ElevatorHelper.resetElevatorEditState(elevator);
            }
            return;
        }
        ElevatorMenuOpenEvent menuOpenEvent = new ElevatorMenuOpenEvent(player, event, elevator);
        Bukkit.getPluginManager().callEvent((Event)menuOpenEvent);
        if (menuOpenEvent.isCancelled()) {
            return;
        }
        InteractMenu.openInteractMenu(menuOpenEvent.getPlayer(), menuOpenEvent.getElevator());
    }

    public static void onElevatorPlace(IElevator elevator) {
    }

    public static void onElevatorUse(Player player, IElevatorEventData elevatorEventData) {
        List<IElevatorAction> actions = elevatorEventData.getDirection() == 1 ? elevatorEventData.getOrigin().getElevatorType().getActionsUp() : elevatorEventData.getOrigin().getElevatorType().getActionsDown();
        if (actions.stream().anyMatch(action -> !action.meetsConditions(elevatorEventData, player))) {
            return;
        }
        ElevatorUseEvent useEvent = new ElevatorUseEvent(player, elevatorEventData);
        Bukkit.getPluginManager().callEvent((Event)useEvent);
        if (useEvent.isCancelled()) {
            return;
        }
        actions.forEach(action -> action.execute(elevatorEventData, player));
        Location teleportLocation = player.getLocation();
        teleportLocation.setY((double)elevatorEventData.getDestination().getLocation().getBlockY() + elevatorEventData.getStandOnAddition() + 1.0);
        Elevators.getFoliaLib().getScheduler().teleportAsync((Entity)player, teleportLocation, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public static boolean hasOrAddPlayerCoolDown(Player player, String key) {
        if (player.hasMetadata((String)(key = "elevator-cooldown-" + (String)key))) {
            MetadataValue value = (MetadataValue)J_U_List.getFirst(player.getMetadata((String)key));
            long lastTime = value.asLong();
            if (System.currentTimeMillis() - lastTime < 1000L) {
                return true;
            }
            player.removeMetadata((String)key, (Plugin)Elevators.getInstance());
        }
        player.setMetadata((String)key, (MetadataValue)new FixedMetadataValue((Plugin)Elevators.getInstance(), (Object)System.currentTimeMillis()));
        return false;
    }

    public static boolean isElevatorDisabled(ShulkerBox shulkerBox) {
        return shulkerBox.hasMetadata("elevator-disabled");
    }
}

