/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.keehl.dialogbuilder.DialogManager;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.api.services.interaction.ISimpleDisplay;
import me.keehl.elevators.helpers.ColorHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.VersionHelper;
import me.keehl.elevators.services.interaction.PagedDisplay;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ElevatorMenuHelper {
    private static DialogManager dialogManager;

    public static void openConfirmMenu(Player player, Consumer<Boolean> onConfirm) {
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)"Are you sure?");
        BiConsumer<InventoryClickEvent, ISimpleDisplay> confirmConsumer = (event, myDisplay) -> {
            if (event.getCurrentItem() == null) {
                return;
            }
            myDisplay.stopReturn();
            onConfirm.accept(event.getCurrentItem().getType() == Material.LIME_WOOL);
        };
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> onConfirm.accept(false));
        for (int i = 0; i < 54; ++i) {
            display.setItemSimple(i, (ItemStack)(i % 9 < 4 ? ItemStackHelper.createItem("Accept", Material.LIME_WOOL, 1) : (i % 9 > 4 ? ItemStackHelper.createItem("Deny", Material.RED_WOOL, 1) : null)), confirmConsumer, new DisplayClickFlag[0]);
        }
        display.open();
    }

    public static void openChooseDyeColorMenu(Player player, String title, Consumer<DyeColor> returnMethod, Runnable onCancel) {
        PagedDisplay<DyeColor> display = new PagedDisplay<DyeColor>(Elevators.getInstance(), player, Arrays.asList(DyeColor.values()), title, onCancel);
        display.onCreateItem(dyeColor -> ItemStackHelper.createItem(ColorHelper.getChatStringFromColor(dyeColor.getColor().asRGB()) + String.valueOf(ChatColor.BOLD) + dyeColor.name(), ItemStackHelper.getVariant(Material.BLACK_DYE, dyeColor), 1));
        display.onClick((dyeColor, event, myDisplay) -> {
            display.stopReturn();
            returnMethod.accept((DyeColor)dyeColor);
        });
        display.open();
    }

    public static Map<String, String> createActionMap(List<String> keyList, List<String> actionList) {
        HashMap<String, String> actions = new HashMap<String, String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String key = keyList.get(i);
            if (actionList.size() <= i) continue;
            actions.put(key, actionList.get(i));
        }
        return actions;
    }

    public static <T> Map<T, Integer> mapToInventorySlot(List<T> objects) {
        HashMap<T, Integer> objectMap = new HashMap<T, Integer>();
        int inventorySize = objects.size() + (9 - objects.size() % 9);
        int numRows = inventorySize / 9;
        int currentItemIndex = 0;
        for (int row = 0; row < numRows && currentItemIndex < objects.size(); ++row) {
            int startColIndex;
            int itemsToPlace = Math.min(9, objects.size() - currentItemIndex);
            for (int col = startColIndex = Math.max((9 - itemsToPlace) / 2, 0); col < startColIndex + itemsToPlace; ++col) {
                int slot = (row + 1) * 9 + col;
                objectMap.put(objects.get(currentItemIndex), slot);
                ++currentItemIndex;
            }
        }
        return objectMap;
    }

    public static <T> ItemStack createValueButton(ItemStack template, T value, Function<T, String> serializeMethod, Map<String, String> actions) {
        ArrayList<Object> lore = new ArrayList<Object>();
        ItemMeta templateMeta = template.getItemMeta();
        if (templateMeta.hasLore()) {
            lore.addAll(Objects.requireNonNull(templateMeta.getLore()));
        }
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Current Value: ");
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            lore.add(boolValue != false ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        } else {
            lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + serializeMethod.apply(value));
        }
        if (!actions.isEmpty()) {
            lore.add("");
            actions.forEach((action, description) -> lore.add(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + action + ": " + String.valueOf(ChatColor.GRAY) + description));
        }
        ItemStack icon = template.clone();
        ItemMeta iconMeta = icon.getItemMeta();
        iconMeta.setLore(lore);
        icon.setItemMeta(iconMeta);
        return icon;
    }

    public static ItemStack createBooleanButton(ItemStack template, boolean value, Map<String, String> actions) {
        return ElevatorMenuHelper.createValueButton(template, value, boolValue -> boolValue != false ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED", actions);
    }

    public static Inventory createInventoryWithMinSlots(int minSlots, String title) {
        int inventorySize = minSlots + (9 - minSlots % 9);
        if (minSlots % 9 == 0) {
            inventorySize -= 9;
        }
        return Bukkit.createInventory(null, (int)inventorySize, (String)title);
    }

    public static void fillEmptySlotsWithPanes(Inventory inventory, DyeColor paneColor) {
        ItemStack pane = ItemStackHelper.createItem(" ", ItemStackHelper.getVariant(Material.BLACK_STAINED_GLASS_PANE, paneColor), 1);
        IntStream.range(0, inventory.getSize()).filter(i -> inventory.getItem(i) == null).forEach(i -> inventory.setItem(i, pane.clone()));
    }

    public static void openMenuFromDisplay(ISimpleDisplay myDisplay, Player player, IElevator elevator, BiConsumer<Player, IElevator> newMethod) {
        myDisplay.stopReturn();
        newMethod.accept(player, elevator);
    }

    public static List<IElevatorAction> getActionsWithSettings(IElevator elevator, boolean up) {
        ArrayList<IElevatorAction> actions = new ArrayList<IElevatorAction>(up ? elevator.getElevatorType(false).getActionsUp() : elevator.getElevatorType(false).getActionsDown());
        actions.removeIf(i -> i.getSettings().isEmpty());
        actions.removeIf(i -> i.getSettings().stream().allMatch(s -> s.isSettingGlobalOnly(elevator)));
        return actions;
    }

    public static DialogManager getDialogManager() {
        if (dialogManager == null && VersionHelper.doesVersionSupportDialogs()) {
            ElevatorMenuHelper.registerDialogManager();
        }
        return dialogManager;
    }

    public static void registerDialogManager() {
        if (dialogManager == null && VersionHelper.doesVersionSupportDialogs()) {
            dialogManager = new DialogManager((Plugin)Elevators.getInstance());
            dialogManager.register();
        }
    }

    public static void unregisterDialogManager() {
        if (dialogManager == null) {
            return;
        }
        dialogManager.unregister();
    }
}

