/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.util.ExecutionMode;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Recipe;
import org.bukkit.permissions.Permissible;

public class ElevatorPermHelper {
    public static <T extends Recipe & Keyed> boolean canCraftElevatorType(IElevatorType elevatorType, Player player, T recipe) {
        if (!((Boolean)Elevators.getSettingService().getElevatorSettingValue(elevatorType, InternalElevatorSettingType.CHECK_PERMS)).booleanValue()) {
            return true;
        }
        return Elevators.getRecipeService().doesPermissibleHavePermissionForRecipe((Permissible)player, recipe);
    }

    public static boolean canDyeElevatorType(IElevatorType elevatorType, Player player, DyeColor color) {
        if (!((Boolean)Elevators.getSettingService().getElevatorSettingValue(elevatorType, InternalElevatorSettingType.CHECK_PERMS)).booleanValue()) {
            return true;
        }
        if (!((Boolean)Elevators.getSettingService().getElevatorSettingValue(elevatorType, InternalElevatorSettingType.SUPPORT_DYING)).booleanValue()) {
            return player.hasPermission(elevatorType.getDyePermission());
        }
        if (player.hasPermission(elevatorType.getDyePermission() + ".*")) {
            return true;
        }
        return player.hasPermission(elevatorType.getDyePermission() + "." + color.toString());
    }

    public static boolean canUseElevator(Player player, IElevatorEventData elevatorEventData) {
        AtomicBoolean hasPermission = new AtomicBoolean(true);
        Consumer<IElevator> checkPermission = elevator -> {
            if (!hasPermission.get()) {
                return;
            }
            if (!Elevators.getHooksService().canUseElevator(player, (IElevator)elevator, false)) {
                hasPermission.set(false);
                return;
            }
            boolean shouldCheckSettings = (Boolean)Elevators.getSettingService().getElevatorSettingValue((IElevator)elevator, InternalElevatorSettingType.CHECK_PERMS);
            if (!shouldCheckSettings || player.hasPermission(elevator.getElevatorType().getUsePermission() + ".*")) {
                return;
            }
            if (!player.hasPermission(elevator.getElevatorType().getUsePermission() + "." + String.valueOf(elevator.getDyeColor()))) {
                hasPermission.set(false);
            }
        };
        ExecutionMode.executeConsumerWithMode(Elevators.getConfigService().getRootConfig().getPermissionMode(), elevatorEventData::getElevatorFromExecutionMode, checkPermission);
        return hasPermission.get();
    }
}

