/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.helpers;

import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.api.models.hooks.PlaceholderHook;
import me.keehl.elevators.helpers.ColorHelper;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.models.AdventureLocaleComponent;
import me.keehl.elevators.models.BungeeLocaleComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageHelper {
    public static ILocaleComponent getLocaleComponent(String message) {
        try {
            Class.forName("net.kyori.adventure.text.TextComponent");
            return new AdventureLocaleComponent(message);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new BungeeLocaleComponent(message);
        }
    }

    public static List<ILocaleComponent> getLocalComponents(List<String> messages) {
        ArrayList<ILocaleComponent> components = new ArrayList<ILocaleComponent>();
        for (String message : messages) {
            components.add(MessageHelper.getLocaleComponent(message));
        }
        return components;
    }

    public static String formatElevatorPlaceholders(CommandSender sender, IElevatorEventData searchResult, String message) {
        message = sender instanceof Player ? message.replace("%player%", sender.getName()) : message.replace("%player%", "Console");
        if (searchResult == null) {
            return message;
        }
        message = message.replace("%elevators_type%", searchResult.getOrigin().getElevatorType().getTypeKey());
        if (searchResult.getDestination() != null && searchResult.getDestination().getShulkerBox() != null) {
            if (message.contains("%elevators_new_floor%")) {
                message = message.replace("%elevators_new_floor%", "" + ElevatorHelper.getFloorNumberOrCount(searchResult.getDestination(), true));
            }
            if (message.contains("%elevators_top_floor%")) {
                message = message.replace("%elevators_top_floor%", "" + ElevatorHelper.getFloorNumberOrCount(searchResult.getDestination(), false));
            }
            if (message.contains("%elevators_new_floor_name%")) {
                message = message.replace("%elevators_new_floor_name%", Elevators.getDataContainerService().getFloorName(searchResult.getDestination()));
            }
        }
        if (searchResult.getOrigin() != null && searchResult.getOrigin().getShulkerBox() != null) {
            if (message.contains("%elevators_old_floor%")) {
                message = message.replace("%elevators_old_floor%", "" + ElevatorHelper.getFloorNumberOrCount(searchResult.getOrigin(), true));
            }
            if (message.contains("%elevators_top_floor%") && searchResult.getDestination().getShulkerBox() == null) {
                message = message.replace("%elevators_top_floor%", "" + ElevatorHelper.getFloorNumberOrCount(searchResult.getOrigin(), false));
            }
            if (message.contains("%elevators_old_floor_name%")) {
                message = message.replace("%elevators_old_floor_name%", Elevators.getDataContainerService().getFloorName(searchResult.getOrigin()));
            }
        }
        return message;
    }

    public static String formatLineColors(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static List<String> formatLore(String message, ChatColor defaultColor) {
        ArrayList<String> messages = new ArrayList<String>();
        String[] words = message.split(" ");
        messages.add(String.valueOf(defaultColor) + words[0]);
        for (int i = 1; i < words.length; ++i) {
            if (((String)J_U_List.getLast(messages) + " " + words[i]).length() <= 30) {
                messages.set(messages.size() - 1, J_U_List.getLast(messages) + " " + words[i]);
                continue;
            }
            messages.add(String.valueOf(defaultColor) + words[i]);
        }
        return messages;
    }

    public static List<String> formatListColors(List<String> messages) {
        if (messages == null) {
            return messages;
        }
        ArrayList<String> finalMessages = new ArrayList<String>();
        messages.forEach(i -> finalMessages.add(MessageHelper.formatLineColors(i)));
        return finalMessages;
    }

    public static String formatPlaceholders(CommandSender sender, String message) {
        if (!(sender instanceof Player)) {
            return message;
        }
        Player player = (Player)sender;
        PlaceholderHook hook = Elevators.getHooksService().getPlaceholderHook();
        if (hook == null) {
            return message;
        }
        return hook.formatPlaceholders(player, message);
    }

    @Nonnull
    public static String hideText(@Nonnull String text) {
        StringBuilder output = new StringBuilder();
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        String hex = ColorHelper.encodeHexString(bytes);
        for (char c : hex.toCharArray()) {
            output.append('\u00a7').append(c);
        }
        return output.toString();
    }

    @Nonnull
    public static String revealText(@Nonnull String text) {
        if (((String)text).isEmpty()) {
            return text;
        }
        if (((String)text).length() % 2 != 0) {
            text = (String)text + " ";
        }
        char[] chars = ((String)text).toCharArray();
        char[] hexChars = new char[chars.length / 2];
        IntStream.range(0, chars.length).filter(value -> value % 2 != 0).forEach(value -> {
            hexChars[value / 2] = chars[value];
        });
        try {
            return new String(ColorHelper.decodeHex(hexChars), StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            return text;
        }
    }

    public static String fixEnum(String input) {
        input = input.toLowerCase();
        String[] words = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            String formattedWord = word.substring(0, 1).toUpperCase() + word.substring(1);
            result.append(formattedWord).append(" ");
        }
        return result.toString();
    }
}

