/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import java.util.ArrayList;
import java.util.Locale;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.localization.BentoBoxLocale;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class BentoBoxHook
extends ProtectionHook {
    Flag useFlag = new Flag.Builder("USE_ELEVATOR", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();
    Flag editNameFlag = new Flag.Builder("EDIT_ELEVATOR_FLOOR_NAME", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();
    Flag editSettingsFlag = new Flag.Builder("EDIT_ELEVATOR_SETTINGS", Material.RED_SHULKER_BOX).mode(Flag.Mode.BASIC).build();

    public BentoBoxHook() {
        super("BentoBox");
        BentoBox.getInstance().getFlagsManager().registerFlag(this.useFlag);
        BentoBox.getInstance().getFlagsManager().registerFlag(this.editNameFlag);
        BentoBox.getInstance().getFlagsManager().registerFlag(this.editSettingsFlag);
        for (Locale objLocale : BentoBox.getInstance().getLocalesManager().getAvailableLocales(true)) {
            BentoBoxLocale locale = (BentoBoxLocale)BentoBox.getInstance().getLocalesManager().getLanguages().get(objLocale);
            if (!locale.contains("protection.flags.USE_ELEVATOR.name")) {
                locale.set("protection.flags.USE_ELEVATOR.name", "Use elevators");
                locale.set("protection.flags.USE_ELEVATOR.description", "Toggle elevators");
            }
            if (!locale.contains("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.name")) {
                locale.set("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.name", "Edit Elevator floor name");
                locale.set("protection.flags.EDIT_ELEVATOR_FLOOR_NAME.description", "Edit the name of the Elevator floor");
            }
            if (locale.contains("protection.flags.EDIT_ELEVATOR_SETTINGS.name")) continue;
            locale.set("protection.flags.EDIT_ELEVATOR_SETTINGS.name", "Edit Elevators settings");
            locale.set("protection.flags.EDIT_ELEVATOR_SETTINGS.description", "Edit the settings of the Elevators");
        }
    }

    @Override
    public void onInit() {
    }

    public boolean isIsland(Location location) {
        return BentoBox.getInstance().getIslands().getIslandAt(location).isPresent();
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.useFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.editNameFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        Location location = elevator.getLocation();
        Island island = BentoBox.getInstance().getIslands().getIslandAt(location).orElse(null);
        if (island == null) {
            return true;
        }
        if (!island.getProtectionBoundingBox().contains(location.getX(), location.getY(), location.getZ())) {
            return true;
        }
        User user = BentoBox.getInstance().getPlayers().getUser(player.getUniqueId());
        if (island.isAllowed(user, this.editSettingsFlag)) {
            return true;
        }
        if (sendMessage) {
            user.sendMessage("general.errors.insufficient-rank", new String[]{"[rank]", user.getTranslation(BentoBox.getInstance().getRanksManager().getRank(island.getRank(user)), new String[0])});
        }
        return false;
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        Island island = BentoBox.getInstance().getIslands().getIslandAt(elevator.getLocation()).orElse(null);
        if (island == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether island");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Bento Box", Material.DIAMOND, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

