/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.HologramHook;
import me.keehl.elevators.api.models.hooks.IElevatorHologram;
import org.bukkit.Location;

public class DecentHologramsHook
implements HologramHook {
    @Override
    public IElevatorHologram createHologram(UUID uuid, IElevator elevator, String ... lines) {
        return new DecentHologramWrapper(uuid, elevator, new String[0]);
    }

    @Override
    public void onInit() {
    }

    public static class DecentHologramWrapper
    implements IElevatorHologram {
        private final Hologram hologram;

        public DecentHologramWrapper(UUID uuid, IElevator elevator, String ... lines) {
            this.hologram = DHAPI.createHologram((String)uuid.toString(), (Location)elevator.getLocation().clone());
            this.hologram.setDownOrigin(true);
            Arrays.stream(lines).forEach(i -> DHAPI.addHologramLine((Hologram)this.hologram, (String)i));
            this.hologram.realignLines();
        }

        @Override
        public void addLine(String text) {
            DHAPI.addHologramLine((Hologram)this.hologram, (String)text);
        }

        @Override
        public void setLines(List<String> text) {
            DHAPI.setHologramLines((Hologram)this.hologram, text);
        }

        @Override
        public double getHeight() {
            return this.hologram.getPage(0).getHeight();
        }

        @Override
        public void teleportTo(Location location) {
            DHAPI.moveHologram((Hologram)this.hologram, (Location)location);
        }

        @Override
        public void onDelete() {
            this.hologram.delete();
        }
    }
}

