/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.List;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.enums.FlagTarget;
import me.angeschossen.lands.api.flags.enums.RoleFlagCategory;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.LandWorld;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LandsHook
extends ProtectionHook {
    private RoleFlag useFlag;
    private RoleFlag settingsFlag;
    private final LandsIntegration lands = LandsIntegration.of((Plugin)ElevatorsAPI.getElevators().getPlugin());

    public LandsHook() {
        super("Lands");
        this.lands.onLoad(() -> {
            this.useFlag = RoleFlag.of((LandsIntegration)this.lands, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)"elevator_use");
            this.useFlag.setDisplayName("Elevator Use");
            this.useFlag.setDescription("Allows the role to use Elevators in this area");
            this.useFlag.setIcon(ItemStackHelper.createItem(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Elevator Use", Material.RED_SHULKER_BOX, 1, this.formatLore("Allows the rule to use Elevators in this area", ChatColor.GRAY)));
            this.useFlag.setAlwaysAllowInWilderness(true);
            this.settingsFlag = RoleFlag.of((LandsIntegration)this.lands, (FlagTarget)FlagTarget.PLAYER, (RoleFlagCategory)RoleFlagCategory.ACTION, (String)"elevator_settings");
            this.settingsFlag.setDisplayName("Elevator Manage");
            this.settingsFlag.setDescription("Allows the role to edit Elevators in this area");
            this.settingsFlag.setIcon(ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "Elevator Manage", Material.LIGHT_GRAY_SHULKER_BOX, 1, this.formatLore("Allows the rule to edit Elevators in this area", ChatColor.GRAY)));
        });
    }

    public List<String> formatLore(String message, ChatColor defaultColor) {
        ArrayList<String> messages = new ArrayList<String>();
        String[] words = message.split(" ");
        messages.add(String.valueOf(defaultColor) + words[0]);
        for (int i = 1; i < words.length; ++i) {
            if (((String)J_U_List.getLast(messages) + " " + words[i]).length() <= 30) {
                messages.set(messages.size() - 1, J_U_List.getLast(messages) + " " + words[i]);
                continue;
            }
            messages.add(String.valueOf(defaultColor) + words[i]);
        }
        return messages;
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.useFlag, null, sendMessage);
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.settingsFlag, null, sendMessage);
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        LandWorld world = this.lands.getWorld(elevator.getLocation().getWorld());
        if (world == null) {
            return true;
        }
        return world.hasRoleFlag(this.lands.getLandPlayer(player.getUniqueId()), elevator.getLocation(), this.settingsFlag, null, sendMessage);
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether this");
        lore.add(String.valueOf(ChatColor.GRAY) + "elevator will check");
        lore.add(String.valueOf(ChatColor.GRAY) + "Land flags for use.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Lands", Material.SHIELD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

