/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.types.BooleanFlag;
import java.util.ArrayList;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlotSquaredHook
extends ProtectionHook {
    private final ElevatorUseFlag useFlag = new ElevatorUseFlag(true);
    private final ElevatorEditNameFlag nameFlag;
    private final ElevatorEditSettingsFlag settingsFlag;
    private final PlotAPI api;

    public PlotSquaredHook() {
        super("PlotSquared");
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.useFlag);
        this.nameFlag = new ElevatorEditNameFlag(true);
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.nameFlag);
        this.settingsFlag = new ElevatorEditSettingsFlag(false);
        GlobalFlagContainer.getInstance().addFlag((PlotFlag)this.settingsFlag);
        this.api = new PlotAPI();
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.useFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.nameFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return false;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null || ((Boolean)currentPlot.getFlag((PlotFlag)this.settingsFlag)).booleanValue()) {
            return true;
        }
        if (currentPlot.getTrusted().contains(player.getUniqueId())) {
            return true;
        }
        if (currentPlot.getMembers().contains(player.getUniqueId())) {
            return true;
        }
        return currentPlot.getOwners().contains(player.getUniqueId());
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        PlotPlayer plotPlayer = this.api.wrapPlayer(player.getUniqueId());
        if (plotPlayer == null) {
            return null;
        }
        Plot currentPlot = plotPlayer.getCurrentPlot();
        if (currentPlot == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether plot");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.AQUA) + String.valueOf(ChatColor.BOLD) + "Plot Squared", Material.DIAMOND_PICKAXE, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    public static class ElevatorUseFlag
    extends BooleanFlag<ElevatorUseFlag> {
        protected ElevatorUseFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.guest_elevators"));
        }

        protected ElevatorUseFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorUseFlag(aBoolean);
        }
    }

    public static class ElevatorEditNameFlag
    extends BooleanFlag<ElevatorEditNameFlag> {
        protected ElevatorEditNameFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.name_elevators"));
        }

        protected ElevatorEditNameFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorEditNameFlag(aBoolean);
        }
    }

    public static class ElevatorEditSettingsFlag
    extends BooleanFlag<ElevatorEditSettingsFlag> {
        protected ElevatorEditSettingsFlag(boolean value) {
            super(value, (Caption)TranslatableCaption.of((String)"flags.settings_elevators"));
        }

        protected ElevatorEditSettingsFlag flagOf(@NotNull Boolean aBoolean) {
            return new ElevatorEditSettingsFlag(aBoolean);
        }
    }
}

