/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import java.util.ArrayList;
import java.util.Optional;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.AreaProvider;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.flag.FlagRegistry;
import net.thenextlvl.protect.service.ProtectionService;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtectHook
extends ProtectionHook {
    private final Flag<Boolean> useFlag;
    private final Flag<Boolean> nameFlag;
    private final Flag<Boolean> settingsFlag;
    private final FlagRegistry flagRegistry = (FlagRegistry)Bukkit.getServicesManager().load(FlagRegistry.class);
    private final AreaProvider areaProvider = (AreaProvider)Bukkit.getServicesManager().load(AreaProvider.class);
    private final ProtectionService protectionService = (ProtectionService)Bukkit.getServicesManager().load(ProtectionService.class);

    public ProtectHook() {
        super("Protect");
        this.useFlag = this.registerFlag("elevator_use");
        this.nameFlag = this.registerFlag("elevator_rename");
        this.settingsFlag = this.registerFlag("elevator_settings");
    }

    @Override
    public void onInit() {
    }

    private Flag<Boolean> registerFlag(@KeyPattern.Value String flagName) {
        NamespacedKey key = new NamespacedKey((Plugin)ElevatorsAPI.getElevators().getPlugin(), flagName);
        Optional flagOpt = this.flagRegistry.getFlag((Key)key);
        return flagOpt.orElseGet(() -> this.flagRegistry.register((Plugin)ElevatorsAPI.getElevators().getPlugin(), flagName, (Object)true));
    }

    public void failed(Player player, String message) {
        player.sendRichMessage("<red><dark_gray>[<dark_red><bold>!</bold></dark_red>]</dark_gray> " + message + "</red>");
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        Area area = this.areaProvider.getArea(elevator.getLocation());
        if (this.protectionService.canPerformAction((Entity)player, area, this.useFlag, null)) {
            return true;
        }
        if (sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return false;
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        Area area = this.areaProvider.getArea(elevator.getLocation());
        if (this.protectionService.canPerformAction((Entity)player, area, this.nameFlag, null)) {
            return true;
        }
        if (sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return false;
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        Area area = this.areaProvider.getArea(elevator.getLocation());
        if (this.protectionService.canPerformAction((Entity)player, area, this.settingsFlag, null)) {
            return true;
        }
        if (sendMessage) {
            this.failed(player, "You are not allowed to do that here!");
        }
        return false;
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether this");
        lore.add(String.valueOf(ChatColor.GRAY) + "elevator will check");
        lore.add(String.valueOf(ChatColor.GRAY) + "Protect flags.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.LIGHT_PURPLE) + String.valueOf(ChatColor.BOLD) + "Protect", Material.SHIELD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

