/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import br.net.fabiozumbi12.RedProtect.Bukkit.API.RedProtectAPI;
import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import java.util.ArrayList;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RedProtectHook
extends ProtectionHook {
    private final RedProtectAPI redProtect = RedProtect.get().getAPI();
    private final String useFlag = "elevators-allow-use";
    private final String settingsFlagName = "elevators-allow-settings";

    public RedProtectHook() {
        super("RedProtect");
        this.redProtect.addFlag(this.useFlag, true, false);
        this.redProtect.addFlag(this.settingsFlagName, false, false);
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        Region region = this.redProtect.getRegion(elevator.getShulkerBox().getLocation());
        if (region == null || region.getFlagBool(this.useFlag)) {
            return true;
        }
        if (region.isLeader(player) || region.isAdmin(player) || region.isMember(player) || player.hasPermission("redprotect.flag.bypass." + this.useFlag)) {
            return true;
        }
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can't interact with this here!");
        }
        return false;
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        return this.canEditSettings(player, elevator, sendMessage);
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        Region region = this.redProtect.getRegion(elevator.getShulkerBox().getLocation());
        if (region == null || region.getFlagBool(this.settingsFlagName)) {
            return true;
        }
        if (region.isLeader(player) || region.isAdmin(player) || player.hasPermission("redprotect.flag.bypass." + this.settingsFlagName)) {
            return true;
        }
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can't interact with this here!");
        }
        return false;
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        Region region = this.redProtect.getRegion(elevator.getLocation());
        if (region == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether claim");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Red Protect", Material.RED_DYE, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

