/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.events.PluginInitializeEvent;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.island.IslandPrivilege;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.api.services.IElevatorListenerService;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;

public class SuperiorSkyblock2Hook
extends ProtectionHook {
    private static final String USE_ELEVATOR_FLAG = "elevators_use";
    private static final String EDIT_NAME_ELEVATOR_FLAG = "elevators_edit_name";
    private static final String EDIT_SETTINGS_ELEVATOR_FLAG = "elevators_edit_settings";
    private static IslandPrivilege USE_ELEVATOR;
    private static IslandPrivilege EDIT_NAME_ELEVATOR;
    private static IslandPrivilege EDIT_SETTINGS_ELEVATOR;
    private static boolean registered;

    public SuperiorSkyblock2Hook() {
        super("SuperiorSkyblock2");
        IElevatorListenerService listenerService = (IElevatorListenerService)Bukkit.getServicesManager().load(IElevatorListenerService.class);
        if (listenerService == null) {
            ElevatorsAPI.log(Level.WARNING, "Elevator Services not been setup yet. SuperiorSkyblock2 hook may not function.");
            return;
        }
        listenerService.registerEventExecutor(PluginInitializeEvent.class, EventPriority.NORMAL, this::onSSB2Enable);
    }

    @Override
    public void onInit() {
    }

    public void onSSB2Enable(PluginInitializeEvent e) {
        try {
            IslandPrivilege.register((String)USE_ELEVATOR_FLAG);
            IslandPrivilege.register((String)EDIT_NAME_ELEVATOR_FLAG);
            IslandPrivilege.register((String)EDIT_SETTINGS_ELEVATOR_FLAG);
            USE_ELEVATOR = IslandPrivilege.getByName((String)USE_ELEVATOR_FLAG);
            EDIT_NAME_ELEVATOR = IslandPrivilege.getByName((String)EDIT_NAME_ELEVATOR_FLAG);
            EDIT_SETTINGS_ELEVATOR = IslandPrivilege.getByName((String)EDIT_SETTINGS_ELEVATOR_FLAG);
            ElevatorsAPI.log(Level.INFO, "Hooked into SuperiorSkyblock2 correctly");
            registered = true;
        }
        catch (Exception ex) {
            ElevatorsAPI.log(Level.WARNING, "Failed to register SSB2 hook. Please create an issue ticket on my GitHub if one doesn't already exist: https://github.com/keehl254/Elevators/issues. Issue:\n", ex);
        }
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), USE_ELEVATOR);
        }
        return true;
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        if (!registered) {
            return null;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island == null) {
            return null;
        }
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether island");
        lore.add(String.valueOf(ChatColor.GRAY) + "guests are blocked from");
        lore.add(String.valueOf(ChatColor.GRAY) + "using this Elevator.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "SuperiorSkyblock2", Material.DIAMOND, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), EDIT_NAME_ELEVATOR);
        }
        return true;
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        if (!registered) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)elevator.getLocation());
        if (island != null) {
            return island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), EDIT_SETTINGS_ELEVATOR);
        }
        return false;
    }

    static {
        registered = false;
    }
}

