/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.commands.CommandUtils;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.ArrayList;
import me.keehl.elevators.api.models.IElevator;
import me.keehl.elevators.api.models.hooks.ProtectionHook;
import me.keehl.elevators.hooks.ItemStackHelper;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WorldGuardHook
extends ProtectionHook {
    private static StateFlag USE_FLAG;
    private static StateFlag SETTINGS_FLAG;

    public WorldGuardHook() {
        super("WorldGuard");
    }

    @Override
    public void onInit() {
        USE_FLAG = this.registerFlag("elevators-allow-use", true);
        SETTINGS_FLAG = this.registerFlag("elevators-allow-settings", false);
    }

    private StateFlag registerFlag(String flagName, boolean defaultValue) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            StateFlag flag = new StateFlag(flagName, defaultValue);
            registry.register((Flag)flag);
            return flag;
        }
        catch (FlagConflictException e) {
            return (StateFlag)registry.get(flagName);
        }
    }

    private void formatAndSendDenyMessage(String what, LocalPlayer localPlayer, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = WorldGuard.getInstance().getPlatform().getMatcher().replaceMacros((Actor)localPlayer, message);
        message = CommandUtils.replaceColorMacros((String)message);
        localPlayer.printRaw(message.replace("%what%", what));
    }

    @Override
    public boolean canPlayerUseElevator(Player player, IElevator elevator, boolean sendMessage) {
        com.sk89q.worldedit.util.Location location;
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        boolean allowed = query.testState(location = BukkitAdapter.adapt((Location)elevator.getLocation()), localPlayer, new StateFlag[]{USE_FLAG});
        if (!allowed && sendMessage) {
            String message = (String)query.queryValue(location, localPlayer, (Flag)Flags.DENY_MESSAGE);
            this.formatAndSendDenyMessage("use elevators", localPlayer, message);
        }
        return allowed;
    }

    @Override
    public boolean canEditName(Player player, IElevator elevator, boolean sendMessage) {
        return this.canEditSettings(player, elevator, sendMessage);
    }

    @Override
    public boolean canEditSettings(Player player, IElevator elevator, boolean sendMessage) {
        com.sk89q.worldedit.util.Location location;
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        boolean allowed = query.testState(location = BukkitAdapter.adapt((Location)elevator.getLocation()), localPlayer, new StateFlag[]{SETTINGS_FLAG});
        if (!allowed && sendMessage) {
            String message = (String)query.queryValue(location, localPlayer, (Flag)Flags.DENY_MESSAGE);
            this.formatAndSendDenyMessage("edit elevator settings", localPlayer, message);
        }
        return allowed;
    }

    @Override
    public ItemStack createIconForElevator(Player player, IElevator elevator) {
        boolean flagEnabled = this.isCheckEnabled(elevator);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Controls whether this");
        lore.add(String.valueOf(ChatColor.GRAY) + "elevator will check");
        lore.add(String.valueOf(ChatColor.GRAY) + "World Guard flags.");
        lore.add("");
        lore.add(String.valueOf(ChatColor.GRAY) + "Status: ");
        lore.add(flagEnabled ? String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "ENABLED" : String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "DISABLED");
        return ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "World Guard", Material.LEAD, 1, lore);
    }

    @Override
    public void onProtectionClick(Player player, IElevator elevator, Runnable onReturn) {
        this.toggleCheckEnabled(elevator);
        onReturn.run();
    }
}

