/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.listeners;

import java.util.logging.Level;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.ElevatorsAPI;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;

public class AutoCrafterListener {
    public static void setupListener() {
        try {
            Class<?> crafterCraftEventClass = Class.forName("org.bukkit.event.block.CrafterCraftEvent");
            Elevators.getListenerService().registerEventExecutor(crafterCraftEventClass, EventPriority.HIGHEST, event -> {
                if (!(event instanceof Cancellable)) {
                    return;
                }
                Cancellable cancellable = (Cancellable)event;
                try {
                    ItemStack result = (ItemStack)event.getClass().getMethod("getResult", new Class[0]).invoke((Object)event, new Object[0]);
                    if (result.getAmount() == 0 || result.getType().isEmpty()) {
                        return;
                    }
                    if (ItemStackHelper.isNotShulkerBox(result.getType())) {
                        return;
                    }
                    IElevatorType elevatorType = ElevatorHelper.getElevatorType(result);
                    if (elevatorType == null) {
                        return;
                    }
                    if (!((Boolean)Elevators.getSettingService().getElevatorSettingValue(elevatorType, InternalElevatorSettingType.CHECK_PERMS)).booleanValue()) {
                        return;
                    }
                    cancellable.setCancelled(true);
                }
                catch (Exception e) {
                    ElevatorsAPI.log(Level.SEVERE, "Error in AutoCrafterListener: ", e);
                }
            });
        }
        catch (Throwable e) {
            ElevatorsAPI.log(Level.SEVERE, "Error in AutoCrafterListener: ", e);
        }
    }
}

