/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.listeners;

import java.util.Map;
import java.util.Random;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.util.InternalElevatorSettingType;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ElevatorPermHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorEventData;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EntityEventExecutor {
    private static final Random random = new Random();

    public static void onJoin(PlayerJoinEvent e) {
        Elevators.getRecipeService().discoverRecipesForPlayer(e.getPlayer());
    }

    public static void onJumpDefault(PlayerMoveEvent event) {
        if (event.getPlayer().isFlying()) {
            return;
        }
        if (Math.ceil(event.getFrom().getY() % 1.0 * 10000.0) / 10000.0 % 0.0625 != 0.0) {
            return;
        }
        if (event.getFrom().getY() >= event.getTo().getY()) {
            return;
        }
        if (Math.ceil((event.getTo().getY() - event.getFrom().getY()) * 10000.0) / 10000.0 % 0.0625 == 0.0) {
            return;
        }
        Block block = event.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(block);
        if (box == null) {
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(box);
        if (elevatorType == null) {
            return;
        }
        if (Elevators.getConfigService().isWorldDisabled(event.getPlayer().getWorld())) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(event.getPlayer(), "message")) {
                Elevators.getLocale().getWorldDisabledMessage().sendFormatted((CommandSender)event.getPlayer(), new ElevatorEventData(event.getPlayer(), elevatorType));
            }
            return;
        }
        Elevator elevator = new Elevator(box, elevatorType);
        if (!Elevators.getHooksService().canUseElevator(event.getPlayer(), elevator, true)) {
            return;
        }
        IElevatorEventData closest = ElevatorHelper.findDestinationElevator(event.getPlayer(), elevator, (byte)1);
        if (closest == null) {
            return;
        }
        if (!ElevatorPermHelper.canUseElevator(event.getPlayer(), closest)) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(event.getPlayer(), "message")) {
                Elevators.getLocale().getCantUseMessage().sendFormatted((CommandSender)event.getPlayer(), closest);
            }
            return;
        }
        ElevatorHelper.onElevatorUse(event.getPlayer(), closest);
    }

    public static void onSneak(PlayerToggleSneakEvent event) {
        if (!event.isSneaking()) {
            return;
        }
        Block block = event.getPlayer().getLocation().getBlock().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(block);
        if (box == null) {
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(box);
        if (elevatorType == null) {
            return;
        }
        if (Elevators.getConfigService().isWorldDisabled(event.getPlayer().getWorld())) {
            Elevators.getLocale().getWorldDisabledMessage().sendFormatted((CommandSender)event.getPlayer(), new ElevatorEventData(event.getPlayer(), elevatorType));
            return;
        }
        Elevator elevator = new Elevator(box, elevatorType);
        if (!Elevators.getHooksService().canUseElevator(event.getPlayer(), elevator, true)) {
            return;
        }
        IElevatorEventData closest = ElevatorHelper.findDestinationElevator(event.getPlayer(), elevator, (byte)-1);
        if (closest == null) {
            return;
        }
        if (!ElevatorPermHelper.canUseElevator(event.getPlayer(), closest)) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(event.getPlayer(), "message")) {
                Elevators.getLocale().getCantUseMessage().sendFormatted((CommandSender)event.getPlayer(), closest);
            }
            return;
        }
        ElevatorHelper.onElevatorUse(event.getPlayer(), closest);
    }

    public static void onRightClick(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.isBlockInHand() && event.getPlayer().isSneaking()) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(event.getClickedBlock());
        if (box == null) {
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(box.getBlock());
        if (elevatorType == null) {
            return;
        }
        event.setCancelled(true);
        if (event.getPlayer().isSneaking()) {
            if (event.getHand() == null || !event.getHand().equals((Object)EquipmentSlot.HAND)) {
                return;
            }
            ElevatorHelper.onElevatorInteract(event.getPlayer(), event, new Elevator(box, elevatorType));
        }
    }

    public static void onPickup(EntityPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (ItemStackHelper.isNotShulkerBox(item.getType())) {
            return;
        }
        if (!ElevatorHelper.isElevator(item)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(item);
        if ((Integer)Elevators.getSettingService().getElevatorSettingValue(elevatorType, InternalElevatorSettingType.MAX_STACK_SIZE) <= 1) {
            return;
        }
        int pickupAmount = item.getAmount();
        Map<ItemStack, Integer> leftoverItems = ItemStackHelper.addElevatorToInventory(elevatorType, item.getAmount(), item.getType(), (Inventory)player.getInventory(), itemMeta.getDisplayName(), itemMeta.getLore());
        if (!leftoverItems.isEmpty()) {
            int itemsLeft = leftoverItems.values().stream().mapToInt(i -> i).sum();
            item.setAmount(itemsLeft);
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        player.incrementStatistic(Statistic.PICKUP, item.getType(), pickupAmount);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.2f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        event.getItem().remove();
    }
}

