/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.listeners;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import elevators.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorEventData;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.models.ILocaleComponent;
import me.keehl.elevators.helpers.ElevatorHelper;
import me.keehl.elevators.helpers.ElevatorPermHelper;
import me.keehl.elevators.helpers.ShulkerBoxHelper;
import me.keehl.elevators.models.Elevator;
import me.keehl.elevators.models.ElevatorEventData;
import me.keehl.elevators.util.paperlib.PaperLib;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PaperEventExecutor {
    public static void onJump(PlayerJumpEvent event) {
        Block block = event.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        ShulkerBox box = ShulkerBoxHelper.getShulkerBox(block);
        if (box == null) {
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(box);
        if (elevatorType == null) {
            return;
        }
        if (Elevators.getConfigService().isWorldDisabled(event.getPlayer().getWorld())) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(event.getPlayer(), "message")) {
                Elevators.getLocale().getWorldDisabledMessage().sendFormatted((CommandSender)event.getPlayer(), new ElevatorEventData(event.getPlayer(), elevatorType));
            }
            return;
        }
        Elevator elevator = new Elevator(box, elevatorType);
        if (!Elevators.getHooksService().canUseElevator(event.getPlayer(), elevator, true)) {
            return;
        }
        IElevatorEventData closest = ElevatorHelper.findDestinationElevator(event.getPlayer(), elevator, (byte)1);
        if (closest == null) {
            return;
        }
        if (!ElevatorPermHelper.canUseElevator(event.getPlayer(), closest)) {
            if (ElevatorHelper.hasOrAddPlayerCoolDown(event.getPlayer(), "message")) {
                Elevators.getLocale().getCantUseMessage().sendFormatted((CommandSender)event.getPlayer(), closest);
            }
            return;
        }
        ElevatorHelper.onElevatorUse(event.getPlayer(), closest);
    }

    public static void onHopperTake(InventoryMoveItemEvent event) {
        if (event.getSource().getType() != InventoryType.SHULKER_BOX && event.getDestination().getType() != InventoryType.SHULKER_BOX) {
            return;
        }
        ItemStack item = event.getItem();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (item.getType().equals((Object)Material.COMMAND_BLOCK) && meta.getDisplayName().equalsIgnoreCase("elevator")) {
            event.setCancelled(true);
            return;
        }
        IElevatorType elevatorType = ElevatorHelper.getElevatorType(event.getItem());
        if (elevatorType != null) {
            meta.setDisplayName(elevatorType.getDisplayName().toLegacyText());
            meta.setLore(J_U_S_Stream.toList(elevatorType.getLore().stream().map(ILocaleComponent::toLegacyText)));
            event.getItem().setItemMeta(meta);
        }
        if (event.getSource().getType() == InventoryType.SHULKER_BOX && ElevatorHelper.isElevator(PaperLib.getHolder(event.getSource(), false).getHolder())) {
            event.setCancelled(true);
        }
        if (event.getDestination().getType() == InventoryType.SHULKER_BOX && ElevatorHelper.isElevator(PaperLib.getHolder(event.getDestination(), false).getHolder())) {
            event.setCancelled(true);
        }
    }
}

