/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.admin;

import java.util.ArrayList;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorActionSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class AdminActionSettingsMenu {
    public static void openAdminActionSettingsMenu(Player player, IElevatorType tempElevatorType, IElevatorAction action, Runnable onReturn) {
        IElevatorType elevatorType = Elevators.getElevatorTypeService().getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        ArrayList settings = new ArrayList(action.getSettings());
        int inventorySize = Math.floorDiv(settings.size() + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Settings > Actions > Action");
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory);
        action.onStartEditing(player, display, null);
        display.onReturn(() -> {
            action.onStopEditing(player, display, null);
            onReturn.run();
        });
        for (int i = 0; i < settings.size(); ++i) {
            IElevatorActionSetting setting = (IElevatorActionSetting)settings.get(i);
            display.setItemSimple(i + 9, setting.createIcon(setting.getGlobalValue(elevatorType), true), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickGlobal(player, elevatorType, () -> AdminActionSettingsMenu.openAdminActionSettingsMenu(player, elevatorType, action, onReturn), (InventoryClickEvent)event);
            }, new DisplayClickFlag[0]);
        }
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

