/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.admin;

import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.menus.admin.AdminActionSettingsMenu;
import me.keehl.elevators.menus.admin.AdminActionsMenu;
import me.keehl.elevators.menus.admin.AdminSettingsMenu;
import me.keehl.elevators.services.interaction.PagedDisplay;
import org.bukkit.entity.Player;

public class AdminCreateActionMenu {
    public static void openAdminCreateActionMenu(Player player, IElevatorType tempElevatorType, List<IElevatorAction> currentActionList) {
        IElevatorType elevatorType = Elevators.getElevatorTypeService().getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        List<String> registeredActions = Elevators.getActionService().getRegisteredActions();
        PagedDisplay<String> display = new PagedDisplay<String>(Elevators.getInstance(), player, registeredActions, "Settings > Actions > Create", () -> AdminSettingsMenu.openAdminSettingsMenu(player, elevatorType));
        display.onCreateItem(Elevators.getActionService()::getActionIcon);
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            IElevatorAction newAction = Elevators.getActionService().createBlankAction(elevatorType, (String)item);
            if (newAction != null) {
                currentActionList.add(newAction);
                if (!newAction.getSettings().isEmpty()) {
                    AdminActionSettingsMenu.openAdminActionSettingsMenu(player, elevatorType, newAction, () -> AdminActionsMenu.openAdminActionsMenu(player, elevatorType, currentActionList));
                    return;
                }
            }
            AdminActionsMenu.openAdminActionsMenu(player, elevatorType, currentActionList);
        });
        display.open();
    }
}

