/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.admin;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorRecipeGroup;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ColorHelper;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.admin.AdminDeleteElevatorRecipeMenu;
import me.keehl.elevators.menus.admin.AdminEditElevatorRecipeMenu;
import me.keehl.elevators.menus.admin.AdminSettingsMenu;
import me.keehl.elevators.services.interaction.PagedDisplay;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminEditRecipesMenu {
    public static void openAdminEditRecipesMenu(Player player, IElevatorType tempElevatorType) {
        IElevatorType elevatorType = Elevators.getElevatorTypeService().getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        PagedDisplay<IElevatorRecipeGroup> display = new PagedDisplay<IElevatorRecipeGroup>(Elevators.getInstance(), player, elevatorType.getRecipeGroups(), "Admin > Settings > Recipes", () -> AdminSettingsMenu.openAdminSettingsMenu(player, elevatorType));
        display.onCreateItem(recipeGroup -> {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)(Math.abs(recipeGroup.getRecipeKey().hashCode()) % 16)));
            if (!recipeGroup.supportsMultiColorOutput() || color == null) {
                color = recipeGroup.getDefaultOutputColor();
            }
            String chatColor = ColorHelper.getChatStringFromColor(color.getColor().asRGB());
            ItemStack icon = ItemStackHelper.createItem(chatColor + String.valueOf(ChatColor.BOLD) + recipeGroup.getRecipeKey(), ItemStackHelper.getVariant(Material.RED_SHULKER_BOX, color), recipeGroup.getAmount());
            ItemMeta meta = icon.getItemMeta();
            assert (meta != null);
            List<CallSite> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add((CallSite)((Object)""));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Left Click: " + String.valueOf(ChatColor.GRAY) + "Edit Recipe")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Shift Click: " + String.valueOf(ChatColor.GRAY) + "Delete Recipe")));
            meta.setLore(lore);
            icon.setItemMeta(meta);
            return icon;
        });
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            if (event.isShiftClick()) {
                AdminDeleteElevatorRecipeMenu.openAdminDeleteElevatorRecipe(player, elevatorType, item);
            } else {
                AdminEditElevatorRecipeMenu.openAdminEditElevatorRecipeMenu(player, elevatorType, item);
            }
        });
        display.onLoad((tempDisplay, page) -> {
            int addRecipeIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addRecipeIndex, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Add Recipe", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                AdminEditElevatorRecipeMenu.openAdminEditElevatorRecipeMenu(player, elevatorType, null);
            }, new DisplayClickFlag[0]);
        });
        display.open();
    }
}

