/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.admin;

import elevators.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.admin.AdminCreateElevatorTypeMenu;
import me.keehl.elevators.menus.admin.AdminDeleteElevatorTypeMenu;
import me.keehl.elevators.menus.admin.AdminSettingsMenu;
import me.keehl.elevators.services.interaction.PagedDisplay;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminMenu {
    public static void openAdminMenu(Player player) {
        PagedDisplay<IElevatorType> display = new PagedDisplay<IElevatorType>(Elevators.getInstance(), player, Elevators.getElevatorTypeService().getExistingElevatorTypes(), "Admin");
        display.onCreateItem(elevatorType -> {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)(Math.abs(elevatorType.getTypeKey().hashCode()) % 16)));
            if (elevatorType.canElevatorBeDyed() && !elevatorType.getRecipeGroups().isEmpty()) {
                color = J_U_List.getFirst(elevatorType.getRecipeGroups()).getDefaultOutputColor();
            }
            ItemStack icon = ItemStackHelper.createItemStackFromElevatorType(elevatorType, color);
            ItemMeta meta = icon.getItemMeta();
            assert (meta != null);
            List<CallSite> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add((CallSite)((Object)""));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Type Key: " + elevatorType.getTypeKey())));
            lore.add((CallSite)((Object)""));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Left Click: " + String.valueOf(ChatColor.GRAY) + "Edit Elevator")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Shift Click: " + String.valueOf(ChatColor.GRAY) + "Delete Elevator")));
            meta.setLore(lore);
            icon.setItemMeta(meta);
            return icon;
        });
        display.onClick((item, event, myDisplay) -> {
            myDisplay.stopReturn();
            if (event.isShiftClick()) {
                AdminDeleteElevatorTypeMenu.openAdminDeleteElevatorTypeMenu(player, item);
            } else {
                AdminSettingsMenu.openAdminSettingsMenu(player, item);
            }
        });
        display.onLoad((tempDisplay, page) -> {
            int addElevatorIndex = display.getDisplay().getInventory().getSize() - 1;
            display.getDisplay().setItemSimple(addElevatorIndex, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Add Elevator", Material.NETHER_STAR, 1), (event, myDisplay) -> {
                myDisplay.stopReturn();
                AdminCreateElevatorTypeMenu.openCreateElevatorTypeMenu(player);
            }, new DisplayClickFlag[0]);
        });
        display.open();
    }
}

