/*
 * Decompiled with CFR 0.152.
 */
package me.keehl.elevators.menus.admin;

import java.util.List;
import me.keehl.elevators.Elevators;
import me.keehl.elevators.api.models.IElevatorAction;
import me.keehl.elevators.api.models.IElevatorSetting;
import me.keehl.elevators.api.models.IElevatorType;
import me.keehl.elevators.api.services.interaction.DisplayClickFlag;
import me.keehl.elevators.helpers.ItemStackHelper;
import me.keehl.elevators.menus.admin.AdminActionsMenu;
import me.keehl.elevators.menus.admin.AdminEditRecipesMenu;
import me.keehl.elevators.menus.admin.AdminMenu;
import me.keehl.elevators.services.interaction.SimpleDisplay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class AdminSettingsMenu {
    public static void openAdminSettingsMenu(Player player, IElevatorType tempElevatorType) {
        IElevatorType elevatorType = Elevators.getElevatorTypeService().getElevatorType(tempElevatorType.getTypeKey());
        if (elevatorType == null) {
            player.closeInventory();
            return;
        }
        List<IElevatorSetting<?>> settings = Elevators.getSettingService().getElevatorSettings();
        int itemAmount = settings.size() + 3;
        List<IElevatorAction> upActions = elevatorType.getActionsUp();
        List<IElevatorAction> downActions = elevatorType.getActionsDown();
        int inventorySize = Math.floorDiv(itemAmount + 8, 9) * 9 + 9;
        Inventory inventory = Bukkit.createInventory(null, (int)inventorySize, (String)"Admin > Settings");
        SimpleDisplay display = new SimpleDisplay(Elevators.getInstance(), player, inventory, () -> AdminMenu.openAdminMenu(player));
        for (int i = 0; i < settings.size(); ++i) {
            IElevatorSetting<?> setting = settings.get(i);
            display.setItemSimple(i + 9, setting.createIcon(setting.getGlobalValue(elevatorType), true), (event, myDisplay) -> {
                myDisplay.stopReturn();
                setting.clickGlobal(player, elevatorType, () -> AdminSettingsMenu.openAdminSettingsMenu(player, elevatorType), (InventoryClickEvent)event);
            }, new DisplayClickFlag[0]);
        }
        display.setItemSimple(inventory.getSize() - 3, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Recipes", Material.MAP, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            AdminEditRecipesMenu.openAdminEditRecipesMenu(player, elevatorType);
        }, new DisplayClickFlag[0]);
        display.setItemSimple(inventory.getSize() - 1, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Downwards Actions", Material.SPECTRAL_ARROW, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            AdminActionsMenu.openAdminActionsMenu(player, elevatorType, downActions);
        }, new DisplayClickFlag[0]);
        display.setItemSimple(inventory.getSize() - 2, ItemStackHelper.createItem(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Upwards Actions", Material.TIPPED_ARROW, 1), (event, myDisplay) -> {
            myDisplay.stopReturn();
            AdminActionsMenu.openAdminActionsMenu(player, elevatorType, upActions);
        }, new DisplayClickFlag[0]);
        display.setReturnButton(0, ItemStackHelper.createItem(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "BACK", Material.ARROW, 1), new DisplayClickFlag[0]);
        display.open();
    }
}

